/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.json;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.IBlockPropertyHandler;
import com.stereowalker.survive.api.json.JsonHolder;
import com.stereowalker.survive.json.property.BlockPropertyHandlerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class BlockTemperatureJsonHolder
implements JsonHolder {
    private static final Marker BLOCK_TEMPERATURE_DATA = MarkerManager.getMarker((String)"BLOCK_TEMPERATURE_DATA");
    private ResourceLocation itemID;
    private final float temperatureModifier;
    private final int range;
    @Deprecated
    private final boolean usesLevelProperty;
    private final List<Triple<IBlockPropertyHandler<?>, List<IBlockPropertyHandler.PropertyPair<?>>, Map<String, Float>>> statePropertyOverride;
    String wo = "NOTHING";

    public BlockTemperatureJsonHolder(ResourceLocation blockID, JsonObject object) {
        String CHANGE_PROPERTY = "blockstate_property_overrides";
        String LEVEL_PROPERTY = "uses_level_property";
        String RANGE = "range";
        float temperatureIn = 0.0f;
        boolean usesLevelPropertyIn = false;
        ArrayList stateChangePropertyIn = Lists.newArrayList();
        int rangeIn = 0;
        this.itemID = blockID;
        if (object.entrySet().size() != 0) {
            this.stopWorking();
            try {
                if (this.hasMemberAndIsPrimitive("temperature_modifier", object)) {
                    temperatureIn = this.workOnFloat("temperature_modifier", object);
                }
                if (this.hasMemberAndIsPrimitive("uses_lit_or_active_property", object)) {
                    this.setWorkingOn("uses_lit_or_active_property");
                    HashMap vals = Maps.newHashMap();
                    vals.put("lit", Float.valueOf(temperatureIn));
                    vals.put("active", Float.valueOf(temperatureIn));
                    temperatureIn = 0.0f;
                    stateChangePropertyIn.add(Triple.of(IBlockPropertyHandler.SAVED_PROPERTIES.get("boolean"), new ArrayList(), (Object)vals));
                    this.stopWorking();
                } else if (this.hasMemberAndIsJsonArray(CHANGE_PROPERTY, object)) {
                    this.setWorkingOn(CHANGE_PROPERTY);
                    for (JsonElement e : object.get(CHANGE_PROPERTY).getAsJsonArray()) {
                        if (!IBlockPropertyHandler.SAVED_PROPERTIES.containsKey(e.getAsJsonObject().get("type").getAsString())) continue;
                        JsonObject o = e.getAsJsonObject();
                        IBlockPropertyHandler<?> handler = IBlockPropertyHandler.SAVED_PROPERTIES.get(o.get("type").getAsString());
                        Map<String, Float> vals = BlockPropertyHandlerImpl.deserialize(handler, o);
                        ArrayList requirements = Lists.newArrayList();
                        if (this.hasMemberAndIsJsonArray("requires", o)) {
                            o.get("requires").getAsJsonArray().forEach(eme -> {
                                String type = eme.getAsJsonObject().get("type").getAsString();
                                eme.getAsJsonObject().remove("type");
                                requirements.add(IBlockPropertyHandler.SAVED_PROPERTIES.get(type).requirements(eme.getAsJsonObject()));
                            });
                        }
                        o.remove("type");
                        stateChangePropertyIn.add(Triple.of(handler, (Object)requirements, vals));
                    }
                    this.stopWorking();
                }
                if (object.has(LEVEL_PROPERTY) && object.get(LEVEL_PROPERTY).isJsonPrimitive()) {
                    this.setWorkingOn(LEVEL_PROPERTY);
                    usesLevelPropertyIn = object.get(LEVEL_PROPERTY).getAsBoolean();
                    this.stopWorking();
                }
                if (object.has(RANGE) && object.get(RANGE).isJsonPrimitive()) {
                    this.setWorkingOn(RANGE);
                    rangeIn = object.get(RANGE).getAsInt();
                    this.stopWorking();
                }
            }
            catch (ClassCastException e) {
                Survive.getInstance().getLogger().warn(BLOCK_TEMPERATURE_DATA, "Loading block temperature data $s from JSON: Parsing element %s: element was wrong type!", (Object)e, (Object)blockID, (Object)this.getworkingOn());
            }
            catch (NumberFormatException e) {
                Survive.getInstance().getLogger().warn(BLOCK_TEMPERATURE_DATA, "Loading block temperature data $s from JSON: Parsing element %s: element was an invalid number!", (Object)e, (Object)blockID, (Object)this.getworkingOn());
            }
        }
        if (rangeIn > 5) {
            Survive.getInstance().getLogger().warn(BLOCK_TEMPERATURE_DATA, "Loading block temperature data $s from JSON: Range should not be greater that 5", (Object)blockID);
            rangeIn = 5;
        }
        if (rangeIn < 0) {
            Survive.getInstance().getLogger().warn(BLOCK_TEMPERATURE_DATA, "Loading block temperature data $s from JSON: Range should not be less than 0", (Object)blockID);
            rangeIn = 0;
        }
        ArrayList toRemove = Lists.newArrayList();
        for (Triple prop : stateChangePropertyIn) {
            if (((Block)BuiltInRegistries.BLOCK.get(blockID)).defaultBlockState().hasProperty(((IBlockPropertyHandler)prop.getLeft()).derivedProperty())) continue;
            boolean found = false;
            for (Property property : ((Block)BuiltInRegistries.BLOCK.get(blockID)).defaultBlockState().getProperties()) {
                if (!property.equals(((IBlockPropertyHandler)prop.getLeft()).derivedProperty())) continue;
                found = true;
                break;
            }
            if (found) continue;
            Survive.getInstance().getLogger().warn(BLOCK_TEMPERATURE_DATA, "Loading block temperature data {} from JSON: This block has doesn't have the \"{}\" property, please remove this line", (Object)blockID, (Object)((IBlockPropertyHandler)prop.getLeft()).derivedProperty().getName());
            toRemove.add(prop);
        }
        toRemove.forEach(s -> stateChangePropertyIn.remove(s));
        if (usesLevelPropertyIn && ((Block)BuiltInRegistries.BLOCK.get(blockID)).defaultBlockState().hasProperty((Property)BlockStateProperties.LEVEL) && ((Block)BuiltInRegistries.BLOCK.get(blockID)).defaultBlockState().hasProperty((Property)BlockStateProperties.LEVEL_CAULDRON) && ((Block)BuiltInRegistries.BLOCK.get(blockID)).defaultBlockState().hasProperty((Property)BlockStateProperties.LEVEL_COMPOSTER) && ((Block)BuiltInRegistries.BLOCK.get(blockID)).defaultBlockState().hasProperty((Property)BlockStateProperties.LEVEL_FLOWING)) {
            Survive.getInstance().getLogger().warn(BLOCK_TEMPERATURE_DATA, "Loading block temperature data $s from JSON: This block does not have the level property, please set this to false", (Object)blockID);
            usesLevelPropertyIn = false;
        }
        this.temperatureModifier = temperatureIn;
        this.usesLevelProperty = usesLevelPropertyIn;
        this.statePropertyOverride = stateChangePropertyIn.isEmpty() ? null : stateChangePropertyIn;
        this.range = rangeIn;
    }

    public ResourceLocation getItemID() {
        return this.itemID;
    }

    public float getTemperatureModifier() {
        return this.temperatureModifier;
    }

    public List<Triple<IBlockPropertyHandler<?>, List<IBlockPropertyHandler.PropertyPair<?>>, Map<String, Float>>> getStateChangeProperty() {
        return this.statePropertyOverride;
    }

    public int getRange() {
        return this.range;
    }

    @Deprecated
    public boolean usesLevelProperty() {
        return this.usesLevelProperty;
    }

    @Override
    public CompoundTag serialize() {
        return null;
    }

    @Override
    public String getworkingOn() {
        return this.wo;
    }

    @Override
    public void setWorkingOn(String member) {
        this.wo = member;
    }

    @Override
    public JsonHolder deserialize(CompoundTag input) {
        return null;
    }
}

