/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.json.property;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.stereowalker.survive.api.IBlockPropertyHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.state.properties.EnumProperty;

public class EnumBlockPropertyHandlerImpl<T extends Enum<T>>
implements IBlockPropertyHandler<T> {
    String name;
    List<String> allowed_values = Lists.newArrayList();
    String className = "";

    protected EnumBlockPropertyHandlerImpl() {
        SAVED_PROPERTIES.put("enum", this);
    }

    @Override
    public Map<String, Float> deserialize(JsonObject object) {
        this.className = object.get("class").getAsString();
        HashMap m = Maps.newHashMap();
        for (Map.Entry pr2 : object.get("values").getAsJsonObject().entrySet()) {
            m.put((String)pr2.getKey() + ":" + object.get("class").getAsString(), Float.valueOf(((JsonElement)pr2.getValue()).getAsFloat()));
        }
        if (object.has("allowed_values")) {
            object.get("allowed_values").getAsJsonArray().forEach(elem -> this.allowed_values.add(elem.getAsString()));
        }
        return m;
    }

    @Override
    public EnumProperty<T> derivedProperty() {
        return EnumBlockPropertyHandlerImpl.obtainProperty(this.name, this.className, this.allowed_values);
    }

    @Override
    public IBlockPropertyHandler.PropertyPair<T> requirements(JsonObject object) {
        ArrayList allowed_values = Lists.newArrayList();
        if (object.has("allowed_values")) {
            object.get("allowed_values").getAsJsonArray().forEach(elem -> allowed_values.add(elem.getAsString()));
        }
        return new IBlockPropertyHandler.PropertyPair<T>(EnumBlockPropertyHandlerImpl.obtainProperty(object.get("property").getAsString(), object.get("class").getAsString(), allowed_values), EnumBlockPropertyHandlerImpl.fetchEnum(object.get("class").getAsString(), object.get("value").getAsString()));
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public T getValue(String value) {
        return (T)EnumBlockPropertyHandlerImpl.fetchEnum(value.split(":")[1], value.split(":")[0]);
    }

    public static <T extends Enum<T>> EnumProperty<T> obtainProperty(String propertyName, String className, List<String> values) {
        try {
            if (values != null && values.size() > 0) {
                Object first = EnumBlockPropertyHandlerImpl.fetchEnum(className, values.get(0));
                return EnumProperty.create((String)propertyName, Class.forName(className), (Collection)Arrays.stream((Enum[])((Enum)first).getDeclaringClass().getEnumConstants()).filter(s -> values.contains(s.name())).collect(Collectors.toList()));
            }
            return EnumProperty.create((String)propertyName, Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <E extends Enum<E>> E fetchEnum(String className, String string) {
        try {
            return (E)Enum.valueOf(Class.forName(className), string);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

