/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.network.protocol.game;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionPacket;
import com.stereowalker.unionlib.util.VersionHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ServerboundThirstMovementPacket
extends ServerboundUnionPacket {
    private float moveF;
    private float moveS;
    private boolean jump;
    public static ResourceLocation id = VersionHelper.toLoc((String)"survive", (String)"serverbound_thirst_movement");

    public ServerboundThirstMovementPacket(float moveF, float moveS, boolean jump) {
        super(null);
        this.moveF = moveF;
        this.moveS = moveS;
        this.jump = jump;
    }

    public ServerboundThirstMovementPacket(RegistryFriendlyByteBuf byteBuf) {
        super(byteBuf);
        this.moveF = byteBuf.readFloat();
        this.moveS = byteBuf.readFloat();
        this.jump = byteBuf.readBoolean();
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.writeFloat(this.moveF);
        byteBuf.writeFloat(this.moveS);
        byteBuf.writeBoolean(this.jump);
    }

    public boolean handleOnServer(ServerPlayer sender) {
        if (Survive.THIRST_CONFIG.enabled) {
            int movM = (int)((this.moveS + this.moveF) * 10.0f);
            float moveMul = movM > 0 ? 1.0f : 0.5f;
            if (sender.isSprinting()) {
                moveMul += 2.0f;
            }
            if (sender.isCrouching()) {
                moveMul += 0.5f;
            }
            if (this.jump) {
                moveMul += 1.5f;
            }
            ((IRealisticEntity)sender).waterData().addExhaustion((Player)sender, 0.1f * moveMul);
        }
        return true;
    }

    public ResourceLocation id() {
        return id;
    }
}

