/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.resource;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.FoodJsonHolder;
import com.stereowalker.unionlib.resource.IResourceReloadListener;
import com.stereowalker.unionlib.util.VersionHelper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class ItemConsummableDataManager
implements IResourceReloadListener<Map<ResourceLocation, FoodJsonHolder>> {
    public CompletableFuture<Map<ResourceLocation, FoodJsonHolder>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, FoodJsonHolder> drinkMap = new HashMap<ResourceLocation, FoodJsonHolder>();
            for (Map.Entry resource : manager.listResources("survive_modifiers/consumables/items", s -> s.toString().endsWith(".json")).entrySet()) {
                ResourceLocation drinkId = VersionHelper.toLoc((String)((ResourceLocation)resource.getKey()).getNamespace(), (String)((ResourceLocation)resource.getKey()).getPath().replace("survive_modifiers/consumables/items/", "").replace(".json", ""));
                if (BuiltInRegistries.ITEM.containsKey(drinkId)) {
                    try (InputStream stream = ((Resource)resource.getValue()).open();
                         InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        FoodJsonHolder drinkData = new FoodJsonHolder(drinkId, object);
                        Survive.getInstance().getLogger().info("Found item consummable data for " + String.valueOf(drinkId));
                        drinkMap.put(drinkId, drinkData);
                    }
                    catch (Exception e) {
                        Survive.getInstance().getLogger().warn("Error reading item drink data " + String.valueOf(drinkId) + "!", (Throwable)e);
                    }
                    continue;
                }
                Survive.getInstance().getLogger().warn("No such item exists with the id " + String.valueOf(drinkId) + "!");
            }
            return drinkMap;
        });
    }

    public CompletableFuture<Void> apply(Map<ResourceLocation, FoodJsonHolder> data, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (ResourceLocation drinkId : data.keySet()) {
                Survive.registerDrinkDataForItem(drinkId, (FoodJsonHolder)data.get(drinkId));
            }
        });
    }

    public ResourceLocation id() {
        return VersionHelper.toLoc((String)"survive:item_data");
    }
}

