/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.item.crafting;

import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.alchemy.SPotions;
import com.stereowalker.survive.world.item.crafting.SRecipeSerializer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CharcoalFilterRecipe
extends CustomRecipe {
    public CharcoalFilterRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        int charcoalFilter = 0;
        int waterBottle = 0;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            PotionContents contents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
            if (stack.getItem() == SItems.CHARCOAL_FILTER || stack.getItem() == SItems.USED_CHARCOAL_FILTER) {
                ++charcoalFilter;
            } else if (contents != null && contents.is(Potions.WATER)) {
                ++waterBottle;
            } else if (stack.getItem() == Items.WATER_BUCKET) {
                ++waterBottle;
            } else if (stack.getItem() == SItems.WATER_BOWL) {
                ++waterBottle;
            } else if (!stack.isEmpty()) {
                return false;
            }
            if (charcoalFilter <= 1 && waterBottle <= true) continue;
            return false;
        }
        return charcoalFilter == 1 && waterBottle == 1;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider ra) {
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            PotionContents contents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
            if (stack.getItem() == SItems.WATER_BOWL) {
                return new ItemStack((ItemLike)SItems.PURIFIED_WATER_BOWL);
            }
            if (stack.getItem() == Items.WATER_BUCKET) {
                return new ItemStack((ItemLike)SItems.PURIFIED_WATER_BUCKET);
            }
            if (contents == null || !contents.is(Potions.WATER)) continue;
            ItemStack copy = stack.copy();
            copy.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(SPotions.PURIFIED_WATER.holder()));
            return copy;
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList nonnulllist = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        int emptySpace = -1;
        boolean needsSpace = false;
        ItemStack filterClone = null;
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.getItem(i);
            if (itemstack.isEmpty()) {
                if (emptySpace != -1) continue;
                emptySpace = i;
                continue;
            }
            if (itemstack.getItem() == SItems.USED_CHARCOAL_FILTER) {
                filterClone = itemstack.copy();
                filterClone.hurtAndBreak(1, null, null, item -> {});
                if (filterClone.isEmpty()) {
                    nonnulllist.set(i, (Object)ItemStack.EMPTY);
                    continue;
                }
                nonnulllist.set(i, (Object)filterClone);
                continue;
            }
            if (itemstack.getItem() != SItems.CHARCOAL_FILTER) continue;
            filterClone = itemstack.transmuteCopy((ItemLike)SItems.USED_CHARCOAL_FILTER, 1);
            filterClone.setDamageValue(1);
            if (itemstack.getCount() == 1) {
                nonnulllist.set(i, (Object)filterClone);
                continue;
            }
            needsSpace = true;
        }
        if (needsSpace) {
            NonNullList nonnulllist2 = NonNullList.withSize((int)(inv.size() + 1), (Object)ItemStack.EMPTY);
            nonnulllist2.set(0, filterClone);
            for (int i = 0; i < nonnulllist.size(); ++i) {
                nonnulllist2.set(i + 1, (Object)((ItemStack)nonnulllist.get(i)));
            }
            return nonnulllist2;
        }
        return nonnulllist;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return SRecipeSerializer.CRAFTING_SPECIAL_CHARCOAL_FILTERING;
    }
}

