/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.block;

import com.stereowalker.survive.api.world.level.block.TemperatureEmitter;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.TemperatureRegulatorPlateItem;
import com.stereowalker.survive.world.level.block.AbstractTemperatureRegulatorBlock;
import com.stereowalker.survive.world.level.block.state.properties.SBlockStateProperties;
import com.stereowalker.survive.world.level.block.state.properties.TempRegulationPlateSize;
import com.stereowalker.survive.world.level.block.state.properties.TempRegulationPlateType;
import com.stereowalker.unionlib.util.math.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;

public class PlatedTemperatureRegulatorBlock
extends AbstractTemperatureRegulatorBlock
implements TemperatureEmitter {
    public static final EnumProperty<TempRegulationPlateType> TEMP_REG_TYPE = SBlockStateProperties.TEMP_REG_TYPE;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public PlatedTemperatureRegulatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(TEMP_REG_TYPE, (Comparable)((Object)TempRegulationPlateType.HEATER))).setValue((Property)RADIATOR_SIZE, (Comparable)((Object)TempRegulationPlateSize.LARGE))).setValue((Property)PLATE_COUNT, (Comparable)Integer.valueOf(0))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getNearestLookingDirection().getOpposite())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(PlatedTemperatureRegulatorBlock.hasPowerInEitherDirection(pContext.getLevel(), pContext.getClickedPos(), pContext.getClickedFace())));
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (PlatedTemperatureRegulatorBlock.hasPowerInEitherDirection(pLevel, pPos, (Direction)pState.getValue((Property)FACING)) && !((Boolean)pState.getValue((Property)POWERED)).booleanValue()) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)));
        } else if (!PlatedTemperatureRegulatorBlock.hasPowerInEitherDirection(pLevel, pPos, (Direction)pState.getValue((Property)FACING)) && ((Boolean)pState.getValue((Property)POWERED)).booleanValue()) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public List<ItemStack> getDrops(BlockState pState, LootParams.Builder pBuilder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.addAll(super.getDrops(pState, pBuilder));
        for (int i = 0; i < (Integer)pState.getValue((Property)AbstractTemperatureRegulatorBlock.PLATE_COUNT); ++i) {
            drops.add(this.getPlateStack(pState));
        }
        return drops;
    }

    public static boolean hasPowerInEitherDirection(Level pLevel, BlockPos pPos, Direction pDirection) {
        return pLevel.hasSignal(pPos.relative(pDirection), pDirection) || pLevel.hasSignal(pPos.relative(pDirection.getOpposite()), pDirection.getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{TEMP_REG_TYPE, RADIATOR_SIZE, PLATE_COUNT, FACING, POWERED, WATERLOGGED});
    }

    @Override
    public boolean canAddPlate(BlockState pState, ItemStack plate) {
        TempRegulationPlateType newControl = null;
        TempRegulationPlateSize newSize = null;
        if (plate.getItem() instanceof TemperatureRegulatorPlateItem) {
            newControl = ((TemperatureRegulatorPlateItem)plate.getItem()).getType();
            newSize = ((TemperatureRegulatorPlateItem)plate.getItem()).getSize();
        }
        return pState.getValue(TEMP_REG_TYPE) == newControl && pState.getValue((Property)RADIATOR_SIZE) == newSize;
    }

    public static Color getColor(BlockState pState) {
        if (pState.getBlock() instanceof PlatedTemperatureRegulatorBlock) {
            if (((Boolean)pState.getValue((Property)POWERED)).booleanValue()) {
                switch ((TempRegulationPlateType)((Object)pState.getValue(TEMP_REG_TYPE))) {
                    case HEATER: {
                        return Color.parse((String)"#bd6d3f");
                    }
                    case CHILLER: {
                        return Color.parse((String)"#7ab2d3");
                    }
                }
            } else {
                return ((TempRegulationPlateType)((Object)pState.getValue(TEMP_REG_TYPE))).getColor();
            }
        }
        return Color.named((String)"white");
    }

    @Override
    public boolean canRemovePlates(BlockState pState) {
        return true;
    }

    @Override
    public ItemStack getPlateStack(BlockState pState) {
        if (pState.getValue((Property)RADIATOR_SIZE) == TempRegulationPlateSize.LARGE && pState.getValue(TEMP_REG_TYPE) == TempRegulationPlateType.HEATER) {
            return new ItemStack((ItemLike)SItems.LARGE_HEATING_PLATE);
        }
        if (pState.getValue((Property)RADIATOR_SIZE) == TempRegulationPlateSize.LARGE && pState.getValue(TEMP_REG_TYPE) == TempRegulationPlateType.CHILLER) {
            return new ItemStack((ItemLike)SItems.LARGE_COOLING_PLATE);
        }
        if (pState.getValue((Property)RADIATOR_SIZE) == TempRegulationPlateSize.MEDIUM && pState.getValue(TEMP_REG_TYPE) == TempRegulationPlateType.HEATER) {
            return new ItemStack((ItemLike)SItems.MEDIUM_HEATING_PLATE);
        }
        if (pState.getValue((Property)RADIATOR_SIZE) == TempRegulationPlateSize.MEDIUM && pState.getValue(TEMP_REG_TYPE) == TempRegulationPlateType.CHILLER) {
            return new ItemStack((ItemLike)SItems.MEDIUM_COOLING_PLATE);
        }
        if (pState.getValue((Property)RADIATOR_SIZE) == TempRegulationPlateSize.SMALL && pState.getValue(TEMP_REG_TYPE) == TempRegulationPlateType.HEATER) {
            return new ItemStack((ItemLike)SItems.SMALL_HEATING_PLATE);
        }
        if (pState.getValue((Property)RADIATOR_SIZE) == TempRegulationPlateSize.SMALL && pState.getValue(TEMP_REG_TYPE) == TempRegulationPlateType.CHILLER) {
            return new ItemStack((ItemLike)SItems.SMALL_COOLING_PLATE);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public float getTemperatureModification(BlockState pState) {
        if (((Boolean)pState.getValue((Property)POWERED)).booleanValue()) {
            float blockTemp = (float)((Integer)pState.getValue((Property)AbstractTemperatureRegulatorBlock.PLATE_COUNT)).intValue() * ((TempRegulationPlateSize)((Object)pState.getValue(AbstractTemperatureRegulatorBlock.RADIATOR_SIZE))).getModifier();
            switch ((TempRegulationPlateType)((Object)pState.getValue(TEMP_REG_TYPE))) {
                case CHILLER: {
                    blockTemp *= -1.0f;
                    break;
                }
                case HEATER: {
                    blockTemp *= 1.0f;
                    break;
                }
                default: {
                    blockTemp *= 0.0f;
                }
            }
            return blockTemp;
        }
        return 0.0f;
    }

    @Override
    public float getModificationRange(BlockState pState) {
        return ((TempRegulationPlateSize)((Object)pState.getValue(AbstractTemperatureRegulatorBlock.RADIATOR_SIZE))).getRange();
    }
}

