/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.block.entity;

import com.stereowalker.survive.world.inventory.SaltBoxMenu;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.component.SDataComponents;
import com.stereowalker.survive.world.level.block.SaltBoxBlock;
import com.stereowalker.survive.world.level.block.entity.SBlockEntityType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SaltBoxBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level p_155062_, BlockPos p_155063_, BlockState p_155064_) {
            SaltBoxBlockEntity.this.playSound(p_155064_, SoundEvents.BARREL_OPEN);
            SaltBoxBlockEntity.this.updateBlockState(p_155064_, true);
        }

        protected void onClose(Level p_155072_, BlockPos p_155073_, BlockState p_155074_) {
            SaltBoxBlockEntity.this.playSound(p_155074_, SoundEvents.BARREL_CLOSE);
            SaltBoxBlockEntity.this.updateBlockState(p_155074_, false);
        }

        protected void openerCountChanged(Level p_155066_, BlockPos p_155067_, BlockState p_155068_, int p_155069_, int p_155070_) {
        }

        protected boolean isOwnContainer(Player p_155060_) {
            if (p_155060_.containerMenu instanceof SaltBoxMenu) {
                Container container = ((SaltBoxMenu)p_155060_.containerMenu).getContainer();
                return container == SaltBoxBlockEntity.this;
            }
            return false;
        }
    };
    long lastGameTickUpdated;
    int[] saltSludge = new int[27];
    private static final int COLS = 9;
    private static final int ROWS = 3;
    private static final int[][] OFFSETS = new int[][]{{-1, -1}, {0, -1}, {1, -1}, {-1, 0}, {1, 0}, {-1, 1}, {0, 1}, {1, 1}};

    public SaltBoxBlockEntity(BlockPos pos, BlockState blockState) {
        super(SBlockEntityType.SALT_BOX, pos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
        tag.putLong("lastGameTickUpdated", this.lastGameTickUpdated);
        for (int i = 0; i < 27; ++i) {
            tag.putLong("sludge" + i, (long)this.saltSludge[i]);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
        this.lastGameTickUpdated = tag.getLong("lastGameTickUpdated");
        for (int i = 0; i < 27; ++i) {
            this.saltSludge[i] = tag.getInt("sludge" + i);
        }
    }

    public int getContainerSize() {
        return 27;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.barrel");
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return new SaltBoxMenu(id, player, (Container)this, this.data());
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    void updateBlockState(BlockState state, boolean open) {
        this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)SaltBoxBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    void playSound(BlockState state, SoundEvent sound) {
        Vec3i vec3i = ((Direction)state.getValue((Property)SaltBoxBlock.FACING)).getNormal();
        double d0 = (double)this.worldPosition.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double d1 = (double)this.worldPosition.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double d2 = (double)this.worldPosition.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        this.level.playSound(null, d0, d1, d2, sound, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }

    public ContainerData data() {
        return new ContainerData(){

            public void set(int pIndex, int pValue) {
                SaltBoxBlockEntity.this.saltSludge[pIndex] = pValue;
            }

            public int getCount() {
                return SaltBoxBlockEntity.this.saltSludge.length;
            }

            public int get(int pIndex) {
                return SaltBoxBlockEntity.this.saltSludge[pIndex];
            }
        };
    }

    public void massivelyExtendLifespan() {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.getItem() != SItems.SEA_SALT || this.saltSludge[i] > 0) continue;
            this.saltSludge[i] = 1000;
            stack.shrink(1);
        }
        long gameTime = this.level.getGameTime();
        if (this.lastGameTickUpdated == 0L) {
            this.lastGameTickUpdated = gameTime;
        }
        long timeSinceLastOpened = gameTime - this.lastGameTickUpdated;
        this.lastGameTickUpdated = gameTime;
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (!SDataComponents.FOOD_STATUS_D.hasData(stack)) continue;
            int sidesCovered = 0;
            for (int n : SaltBoxBlockEntity.get8Neighbors(i)) {
                if (n < 0 || SDataComponents.FOOD_STATUS_D.hasData((ItemStack)this.items.get(n)) || this.saltSludge[n] <= 0) continue;
                ++sidesCovered;
                int n2 = n;
                this.saltSludge[n2] = this.saltSludge[n2] - 1;
            }
            if (sidesCovered <= 0) continue;
            float perc = 1.0E-4f * (float)sidesCovered + 0.9991f;
            float efficiency = (float)timeSinceLastOpened * perc;
            if (timeSinceLastOpened <= 2L) {
                efficiency = 1.0f;
            }
            float eff = efficiency;
            float salt = (float)timeSinceLastOpened * ((float)sidesCovered / 8.0f / 96.0f);
            SDataComponents.FOOD_STATUS_D.editData(stack, food_status -> food_status.extendTime(eff).increaseSalt(salt / 8.0f));
        }
    }

    public void setItem(int pIndex, ItemStack pStack) {
        System.out.println("Index " + pIndex);
        int[] saltSlots = new int[]{0, 8};
        super.setItem(pIndex, pStack);
    }

    public static int[] get8Neighbors(int index) {
        int[] neighbors = new int[8];
        if (index >= 0 && index < 27) {
            int row = index / 9;
            int col = index % 9;
            for (int i = 0; i < OFFSETS.length; ++i) {
                int dx = OFFSETS[i][0];
                int dy = OFFSETS[i][1];
                int nr = row + dy;
                int nc = col + dx;
                neighbors[i] = nr < 0 || nr >= 3 || nc < 0 || nc >= 9 ? -1 : nr * 9 + nc;
            }
        }
        return neighbors;
    }
}

