/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.temperature;

import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.util.math.UnionMathHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class TemperatureModifier {
    private ResourceLocation id;
    private double mod;
    private ContributingFactor factor;

    public TemperatureModifier() {
    }

    public TemperatureModifier(ResourceLocation id, double mod) {
        this.id = id;
        this.mod = mod;
        this.factor = ContributingFactor.INTERNAL;
    }

    public TemperatureModifier(ResourceLocation id, double mod, ContributingFactor factor) {
        this.id = id;
        this.mod = mod;
        this.factor = factor;
    }

    public double getMod() {
        return this.mod;
    }

    public ContributingFactor getFactor() {
        return this.factor;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public CompoundTag write(CompoundTag nbt) {
        nbt.putString("id", this.id.toString());
        nbt.putDouble("mod", this.mod);
        nbt.putInt("factor", this.factor.ordinal());
        return nbt;
    }

    public void read(CompoundTag nbt) {
        this.id = VersionHelper.toLoc((String)nbt.getString("id"));
        this.mod = nbt.getDouble("mod");
        this.factor = nbt.getInt("factor") >= ContributingFactor.values().length ? ContributingFactor.INTERNAL : ContributingFactor.values()[nbt.getInt("factor")];
    }

    public TemperatureModifier setMod(double mod) {
        this.mod = UnionMathHelper.roundDecimal((int)3, (double)mod);
        return this;
    }

    public TemperatureModifier setFactor(ContributingFactor factor) {
        this.factor = factor;
        return this;
    }

    public String toString() {
        return "{id: " + String.valueOf(this.id) + ", modifier: " + this.mod + ", contributing factor: " + String.valueOf((Object)this.factor) + "}";
    }

    public static enum ContributingFactor {
        ENVIRONMENTAL,
        INTERNAL;

    }
}

