/*
 * Decompiled with CFR 0.152.
 */
package me.armyfury.summonfriendlymob;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.armyfury.summonfriendlymob.Metrics;
import me.armyfury.summonfriendlymob.MobSettings;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.json.JSONObject;

public class SummonFriendlyMob
extends JavaPlugin
implements Listener {
    private static final List<String> SUPPORTED_VERSIONS = Arrays.asList("1.14", "1.14.1", "1.14.2", "1.14.3", "1.14.4");
    private final Map<UUID, UUID> summonerMap = new HashMap<UUID, UUID>();
    private Plugin plugin;
    private FileConfiguration config;
    private boolean UniversallyFriendly;
    private boolean SaveFriendliness;
    private boolean UpdateNotifier;
    private boolean AllowAttack;
    private boolean AllowCustomMobSettings;
    File pluginsFolder = this.getDataFolder().getParentFile();
    File sfmfolder = new File(this.pluginsFolder, "SummonFriendlyMobs");
    File mobConfigFile;
    YamlConfiguration mobConfig;

    public void onEnable() {
        this.plugin = this;
        this.pluginsFolder = this.getDataFolder().getParentFile();
        this.sfmfolder = new File(this.pluginsFolder, "SummonFriendlyMobs");
        int pluginId = 23162;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        String version = Bukkit.getVersion();
        boolean compatible = SUPPORTED_VERSIONS.stream().anyMatch(version::contains);
        if (!compatible) {
            this.getLogger().severe("This version of the plugin is only compatible with Minecraft version 1.14.x");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        SummonFriendlyMobCommand commandExecutor = new SummonFriendlyMobCommand();
        GiveSpecialSpawnEggCommand giveSpawnEggCommand = new GiveSpecialSpawnEggCommand();
        this.getCommand("summonfriendlymob").setExecutor((CommandExecutor)commandExecutor);
        this.getCommand("summonfriendlymob").setTabCompleter((TabCompleter)commandExecutor);
        this.getCommand("givespecialspawnegg").setExecutor((CommandExecutor)giveSpawnEggCommand);
        this.getCommand("givespecialspawnegg").setTabCompleter((TabCompleter)giveSpawnEggCommand);
        this.getCommand("attack").setExecutor((CommandExecutor)new AttackCommand(this.summonerMap));
        this.getCommand("mobs").setExecutor((CommandExecutor)new MobsCommand());
        this.getCommand("sfmreload").setExecutor((CommandExecutor)new ReloadCommand(this));
        this.getServer().getPluginManager().addPermission(new Permission("summonfriendlymob.check", PermissionDefault.TRUE));
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.setupConfig();
        this.UniversallyFriendly = this.config.getBoolean("UniversallyFriendly", false);
        this.SaveFriendliness = this.config.getBoolean("SaveFriendliness", false);
        this.UpdateNotifier = this.config.getBoolean("UpdateNotifier", true);
        this.AllowAttack = this.config.getBoolean("AllowAttack", true);
        this.AllowCustomMobSettings = this.config.getBoolean("AllowCustomMobSettings", false);
        Callable<String> ufs = () -> Boolean.toString(this.UniversallyFriendly);
        Callable<String> sfs = () -> Boolean.toString(this.SaveFriendliness);
        Callable<String> uns = () -> Boolean.toString(this.UpdateNotifier);
        new Metrics.SimplePie("universallyfriendly", ufs);
        new Metrics.SimplePie("savefriendliness", sfs);
        new Metrics.SimplePie("updatenotifier", uns);
        if (this.SaveFriendliness) {
            this.loadSummonerMap();
        }
        if (this.UpdateNotifier) {
            this.checkForUpdates();
        }
        if (this.AllowCustomMobSettings) {
            this.createMobConfig();
        }
    }

    public void onDisable() {
        if (this.SaveFriendliness) {
            this.saveSummonerMap();
        }
    }

    public void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                String currentVersion = this.getDescription().getVersion();
                String mcVersion = this.getMinecraftVersion();
                String latestVersion = this.getLatestVersionForMinecraft(mcVersion);
                if (latestVersion != null && !currentVersion.equals(latestVersion)) {
                    this.getLogger().warning("Your plugin is outdated! Current version: " + currentVersion + ", Latest version for MC " + mcVersion + ": " + latestVersion);
                    this.getLogger().warning("Get the latest version from: https://modrinth.com/plugin/summonfriendlymobs");
                }
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to check for plugin updates: " + e.getMessage());
            }
        });
    }

    private String getMinecraftVersion() {
        Server server = Bukkit.getServer();
        String versionString = server.getVersion();
        Pattern pattern = Pattern.compile("\\(MC: ([^\\)]+)\\)");
        Matcher matcher = pattern.matcher(versionString);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String getLatestVersionForMinecraft(String mcVersion) {
        try {
            String inputLine;
            URL url = new URL("https://raw.githubusercontent.com/armyfury/summonfriendlymobsversionchecker/main/version.json");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
            connection.disconnect();
            JSONObject json = new JSONObject(content.toString());
            if (json.has(mcVersion)) {
                return json.getString(mcVersion);
            }
            this.getLogger().warning("No specific plugin version found for Minecraft version: " + mcVersion);
            return null;
        }
        catch (Exception e) {
            this.getLogger().severe("Error checking for updates: " + e.getMessage());
            return null;
        }
    }

    private void saveSummonerMap() {
        this.getLogger().info("Saving Friendliness...");
        try {
            File summonmap;
            File pluginsFolder = this.getDataFolder().getParentFile();
            File sfmfolder = new File(pluginsFolder, "SummonFriendlyMobs");
            if (!sfmfolder.exists()) {
                this.getLogger().info("Config folder not found, creating folder...");
                sfmfolder.mkdirs();
            }
            if (!(summonmap = new File(sfmfolder, "summonerMap.dat")).exists()) {
                try {
                    summonmap.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(summonmap));
            oos.writeObject(this.summonerMap);
            oos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getLogger().severe("Error while saving file. Please report this to ArmyFury https://discord.gg/aEc7yqecYn");
        }
    }

    private void loadSummonerMap() {
        File summonmap;
        this.getLogger().info("Loading Friendliness...");
        File pluginsFolder = this.getDataFolder().getParentFile();
        File sfmfolder = new File(pluginsFolder, "SummonFriendlyMobs");
        if (!sfmfolder.exists()) {
            this.getLogger().info("Config folder not found, creating folder...");
            sfmfolder.mkdirs();
        }
        if ((summonmap = new File(sfmfolder, "summonerMap.dat")).exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(summonmap));
                Map loadedMap = (Map)ois.readObject();
                this.summonerMap.clear();
                this.summonerMap.putAll(loadedMap);
                ois.close();
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void setupConfig() {
        File configFile;
        File pluginsFolder = this.getDataFolder().getParentFile();
        File sfmfolder = new File(pluginsFolder, "SummonFriendlyMobs");
        if (!sfmfolder.exists()) {
            this.getLogger().info("Config folder not found, creating folder...");
            sfmfolder.mkdirs();
        }
        if (!(configFile = new File(sfmfolder, "config.yml")).exists()) {
            try {
                configFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.addCommentsToFile(configFile);
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
        if (!this.config.contains("UniversallyFriendly")) {
            this.config.set("UniversallyFriendly", (Object)false);
            try {
                this.config.save(configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!this.config.contains("SaveFriendliness")) {
            this.config.set("SaveFriendliness", (Object)false);
            try {
                this.config.save(configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!this.config.contains("UpdateNotifier")) {
            this.config.set("UpdateNotifier", (Object)true);
            try {
                this.config.save(configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!this.config.contains("AllowAttack")) {
            this.config.set("AllowAttack", (Object)true);
            try {
                this.config.save(configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!this.config.contains("AllowCustomMobSettings")) {
            this.config.set("AllowCustomMobSettings", (Object)false);
            try {
                this.config.save(configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void addCommentsToFile(File configFile) {
        try {
            List<String> lines = Files.readAllLines(configFile.toPath());
            if (lines.isEmpty() || !Objects.equals(lines.get(1), "# Config version: 3.0  // DO NOT TOUCH 1ST 2 LINES AS THEY ARE USED TO UPDATE CONFIG")) {
                lines.clear();
                lines.add(0, "# For help related to the plugin, reach out to me on my discord server -> https://discord.gg/aEc7yqecYn");
                lines.add(1, "# Config version: 3.0  // DO NOT TOUCH 1ST 2 LINES AS THEY ARE USED TO UPDATE CONFIG");
                lines.add("# UniversallyFriendly: Toggle whether mobs summoned by this plugin are Friendly to only the summoner or to all player");
                lines.add("# SaveFriendliness: Toggle whether to keep friendliness of the mobs even after the server restarts");
                lines.add("# UpdateNotifier: Toggle whether to notify for newer versions of the plugin");
                lines.add("# AllowAttack: Toggle whether to allow players to use /attack command or not");
                lines.add("# AllowCustomMobSettings: Toggle whether to use settings for mobs from mobs.yml or not");
            }
            FileWriter writer = new FileWriter(configFile);
            for (String line : lines) {
                writer.write(line + System.lineSeparator());
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createMobConfig() {
        this.mobConfigFile = new File(this.sfmfolder, "mobs.yml");
        if (!this.mobConfigFile.exists()) {
            this.getLogger().info("mobs.yml not found. Downloading default settings...");
            try {
                String version = this.getMinecraftVersion();
                if (version.indexOf(".") != version.lastIndexOf(".")) {
                    version = version.substring(0, version.lastIndexOf("."));
                }
                URL url = new URL("https://raw.githubusercontent.com/ArmyFury/summonfriendlymobsversionchecker/refs/heads/main/" + version + "/mobs.yml");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                try (InputStream inputStream = connection.getInputStream();
                     FileOutputStream outputStream = new FileOutputStream(this.mobConfigFile);){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                }
                this.getLogger().info("mobs.yml downloaded successfully.");
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to download mobs.yml: " + e.getMessage());
            }
        }
        this.mobConfig = YamlConfiguration.loadConfiguration((File)this.mobConfigFile);
    }

    public MobSettings getMobSettings(EntityType type) {
        this.mobConfigFile = new File(this.sfmfolder, "mobs.yml");
        this.mobConfig = YamlConfiguration.loadConfiguration((File)this.mobConfigFile);
        String path = type.name().toLowerCase();
        if (!this.mobConfig.contains(path)) {
            return null;
        }
        double health = this.mobConfig.getDouble(path + ".health", 20.0);
        double movementSpeed = this.mobConfig.getDouble(path + ".movementSpeed", 0.2);
        String displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)this.mobConfig.getString(path + ".displayName", type.name()));
        return new MobSettings(health, movementSpeed, displayName);
    }

    public void applyMobSettings(LivingEntity entity, MobSettings settings) {
        AttributeInstance speedAttribute;
        if (settings.getDisplayName() != null && !entity.getName().equals(settings.getDisplayName())) {
            entity.setCustomName(settings.getDisplayName());
            entity.setCustomNameVisible(true);
        }
        double maxHealth = settings.getHealth();
        AttributeInstance healthAttribute = entity.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (healthAttribute != null) {
            healthAttribute.setBaseValue(maxHealth);
        }
        entity.setHealth(Math.min(maxHealth, entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()));
        if (settings.getMovementSpeed() > 0.0 && (speedAttribute = entity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED)) != null) {
            speedAttribute.setBaseValue(settings.getMovementSpeed());
        }
    }

    private Material getSpawnEggMaterial(EntityType entityType) {
        switch (entityType) {
            case CREEPER: {
                return Material.CREEPER_SPAWN_EGG;
            }
            case SKELETON: {
                return Material.SKELETON_SPAWN_EGG;
            }
            case SPIDER: {
                return Material.SPIDER_SPAWN_EGG;
            }
            case ZOMBIE: {
                return Material.ZOMBIE_SPAWN_EGG;
            }
            case SLIME: {
                return Material.SLIME_SPAWN_EGG;
            }
            case GHAST: {
                return Material.GHAST_SPAWN_EGG;
            }
            case PIG_ZOMBIE: {
                return Material.ZOMBIE_PIGMAN_SPAWN_EGG;
            }
            case ENDERMAN: {
                return Material.ENDERMAN_SPAWN_EGG;
            }
            case CAVE_SPIDER: {
                return Material.CAVE_SPIDER_SPAWN_EGG;
            }
            case SILVERFISH: {
                return Material.SILVERFISH_SPAWN_EGG;
            }
            case BLAZE: {
                return Material.BLAZE_SPAWN_EGG;
            }
            case MAGMA_CUBE: {
                return Material.MAGMA_CUBE_SPAWN_EGG;
            }
            case BAT: {
                return Material.BAT_SPAWN_EGG;
            }
            case WITCH: {
                return Material.WITCH_SPAWN_EGG;
            }
            case ENDERMITE: {
                return Material.ENDERMITE_SPAWN_EGG;
            }
            case GUARDIAN: {
                return Material.GUARDIAN_SPAWN_EGG;
            }
            case SHULKER: {
                return Material.SHULKER_SPAWN_EGG;
            }
            case PIG: {
                return Material.PIG_SPAWN_EGG;
            }
            case SHEEP: {
                return Material.SHEEP_SPAWN_EGG;
            }
            case COW: {
                return Material.COW_SPAWN_EGG;
            }
            case CHICKEN: {
                return Material.CHICKEN_SPAWN_EGG;
            }
            case SQUID: {
                return Material.SQUID_SPAWN_EGG;
            }
            case WOLF: {
                return Material.WOLF_SPAWN_EGG;
            }
            case MUSHROOM_COW: {
                return Material.MOOSHROOM_SPAWN_EGG;
            }
            case OCELOT: {
                return Material.OCELOT_SPAWN_EGG;
            }
            case HORSE: {
                return Material.HORSE_SPAWN_EGG;
            }
            case RABBIT: {
                return Material.RABBIT_SPAWN_EGG;
            }
            case POLAR_BEAR: {
                return Material.POLAR_BEAR_SPAWN_EGG;
            }
            case LLAMA: {
                return Material.LLAMA_SPAWN_EGG;
            }
            case PARROT: {
                return Material.PARROT_SPAWN_EGG;
            }
            case VILLAGER: {
                return Material.VILLAGER_SPAWN_EGG;
            }
            case TURTLE: {
                return Material.TURTLE_SPAWN_EGG;
            }
            case PHANTOM: {
                return Material.PHANTOM_SPAWN_EGG;
            }
            case DROWNED: {
                return Material.DROWNED_SPAWN_EGG;
            }
            case DOLPHIN: {
                return Material.DOLPHIN_SPAWN_EGG;
            }
            case PANDA: {
                return Material.PANDA_SPAWN_EGG;
            }
            case PILLAGER: {
                return Material.PILLAGER_SPAWN_EGG;
            }
            case RAVAGER: {
                return Material.RAVAGER_SPAWN_EGG;
            }
            case ELDER_GUARDIAN: {
                return Material.ELDER_GUARDIAN_SPAWN_EGG;
            }
            case EVOKER: {
                return Material.EVOKER_SPAWN_EGG;
            }
            case STRAY: {
                return Material.STRAY_SPAWN_EGG;
            }
            case VEX: {
                return Material.VEX_SPAWN_EGG;
            }
            case VINDICATOR: {
                return Material.VINDICATOR_SPAWN_EGG;
            }
            case ZOMBIE_VILLAGER: {
                return Material.ZOMBIE_VILLAGER_SPAWN_EGG;
            }
            case FOX: {
                return Material.FOX_SPAWN_EGG;
            }
            case WITHER_SKELETON: {
                return Material.WITHER_SKELETON_SPAWN_EGG;
            }
            case TRADER_LLAMA: {
                return Material.TRADER_LLAMA_SPAWN_EGG;
            }
        }
        throw new IllegalArgumentException("Unsupported entity type: " + entityType);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack item;
        if (event.getHand() == EquipmentSlot.HAND && (event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.RIGHT_CLICK_AIR) && event.getItem() != null && event.getItem().getType().toString().endsWith("_SPAWN_EGG") && (item = event.getItem()).hasItemMeta() && item.getItemMeta().getPersistentDataContainer().has(new NamespacedKey((Plugin)this, "specialSpawnEgg"), PersistentDataType.STRING)) {
            Player player = event.getPlayer();
            EntityType entityType = EntityType.valueOf((String)((String)item.getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)this, "specialSpawnEgg"), PersistentDataType.STRING)));
            Block targetBlock = player.getTargetBlockExact(5);
            if (targetBlock != null) {
                Location spawnLocation = targetBlock.getLocation().add(0.0, 1.0, 0.0);
                LivingEntity entity = (LivingEntity)player.getWorld().spawnEntity(spawnLocation, entityType);
                this.summonerMap.put(entity.getUniqueId(), player.getUniqueId());
                if (this.AllowCustomMobSettings) {
                    MobSettings settings = this.getMobSettings(entityType);
                    this.applyMobSettings(entity, settings);
                }
                player.sendMessage(ChatColor.GREEN + "Spawned a friendly " + entityType.name() + " at " + spawnLocation.toVector());
                if (!Objects.equals(String.valueOf(player.getGameMode()), "CREATIVE")) {
                    item.setAmount(item.getAmount() - 1);
                }
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onEntityTarget(EntityTargetEvent event) {
        Player targetPlayer;
        LivingEntity entity;
        UUID summonerUUID;
        if (event.getEntity() instanceof LivingEntity && (summonerUUID = this.summonerMap.get((entity = (LivingEntity)event.getEntity()).getUniqueId())) != null && event.getTarget() instanceof Player && ((targetPlayer = (Player)event.getTarget()).getUniqueId().equals(summonerUUID) || this.UniversallyFriendly)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPufferfishPoison(EntityDamageByEntityEvent event) {
        PufferFish pufferfish;
        UUID summonerUUID;
        if (event.getDamager() instanceof PufferFish && (summonerUUID = this.summonerMap.get((pufferfish = (PufferFish)event.getDamager()).getUniqueId())) != null && event.getEntity() instanceof Player && ((Player)event.getEntity()).getPlayer().getUniqueId().equals(summonerUUID)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMobConvert(EntityTransformEvent event) {
        UUID pUUID;
        UUID summonerUUID;
        if (event.getEntity() instanceof Zombie && event.getTransformedEntity() instanceof Drowned) {
            UUID zombieUUID = event.getEntity().getUniqueId();
            UUID summonerUUID2 = this.summonerMap.get(zombieUUID);
            if (summonerUUID2 != null) {
                this.summonerMap.put(event.getTransformedEntity().getUniqueId(), summonerUUID2);
            }
        } else if (event.getEntity() instanceof Skeleton && event.getTransformedEntity() instanceof Stray) {
            UUID skeleUUID = event.getEntity().getUniqueId();
            UUID summonerUUID3 = this.summonerMap.get(skeleUUID);
            if (summonerUUID3 != null) {
                this.summonerMap.put(event.getTransformedEntity().getUniqueId(), summonerUUID3);
            }
        } else if (event.getEntity() instanceof Pig && event.getTransformedEntity() instanceof PigZombie && (summonerUUID = this.summonerMap.get(pUUID = event.getEntity().getUniqueId())) != null) {
            this.summonerMap.put(event.getTransformedEntity().getUniqueId(), summonerUUID);
        }
    }

    @EventHandler
    public void onSlimeOrMagmaCubeSplit(final EntityDeathEvent event) {
        UUID originalEntityUUID;
        UUID summonerUUID;
        if ((event.getEntity() instanceof Slime || event.getEntity() instanceof MagmaCube) && (summonerUUID = this.summonerMap.get(originalEntityUUID = event.getEntity().getUniqueId())) != null) {
            new BukkitRunnable(this){
                final /* synthetic */ SummonFriendlyMob this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    for (Entity entity : event.getEntity().getNearbyEntities(1.0, 1.0, 1.0)) {
                        if (!(entity instanceof Slime) && !(entity instanceof MagmaCube)) continue;
                        this.this$0.summonerMap.put(entity.getUniqueId(), summonerUUID);
                    }
                }
            }.runTaskLater(this.plugin, 1L);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        UUID guardianUUID;
        UUID summonerUUID;
        if (event.getDamager() instanceof Guardian && event.getEntity() instanceof Player && (summonerUUID = this.summonerMap.get(guardianUUID = event.getDamager().getUniqueId())) != null && event.getEntity().getUniqueId().equals(summonerUUID) && event.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        UUID deadmob = this.summonerMap.get(entity.getUniqueId());
        if (deadmob != null) {
            this.summonerMap.remove(deadmob);
        }
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (event.getEntity() instanceof Vex && Objects.equals(event.getSpawnReason().toString(), "DEFAULT")) {
            Vex vex = (Vex)event.getEntity();
            LivingEntity summoner = this.findFriendlyEvoker((Entity)event.getEntity());
            if (summoner instanceof Player) {
                Player summonerPlayer = (Player)summoner;
                this.summonerMap.put(vex.getUniqueId(), summonerPlayer.getUniqueId());
            }
        }
    }

    private LivingEntity findFriendlyEvoker(Entity vex) {
        for (Entity entity : vex.getWorld().getEntities()) {
            Evoker evoker;
            if (!(entity instanceof Evoker) || !this.summonerMap.containsKey((evoker = (Evoker)entity).getUniqueId())) continue;
            return Bukkit.getPlayer((UUID)this.summonerMap.get(evoker.getUniqueId()));
        }
        return null;
    }

    public class SummonFriendlyMobCommand
    implements CommandExecutor,
    TabCompleter {
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (args.length == 1 || args.length == 4) {
                    try {
                        EntityType entityType = EntityType.valueOf((String)args[0].toUpperCase());
                        Location spawnLocation = player.getLocation();
                        if (args.length == 4) {
                            double x = this.parseCoordinate(args[1], spawnLocation.getX());
                            double y = this.parseCoordinate(args[2], spawnLocation.getY());
                            double z = this.parseCoordinate(args[3], spawnLocation.getZ());
                            spawnLocation = new Location(player.getWorld(), x, y, z);
                        }
                        LivingEntity entity = (LivingEntity)player.getWorld().spawnEntity(spawnLocation, entityType);
                        SummonFriendlyMob.this.summonerMap.put(entity.getUniqueId(), player.getUniqueId());
                        player.sendMessage("Summoned a " + entityType.name() + " at coordinates (" + spawnLocation.getBlockX() + ", " + spawnLocation.getBlockY() + ", " + spawnLocation.getBlockZ() + ")!");
                        if (SummonFriendlyMob.this.AllowCustomMobSettings) {
                            MobSettings settings = SummonFriendlyMob.this.getMobSettings(entityType);
                            SummonFriendlyMob.this.applyMobSettings(entity, settings);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        player.sendMessage(ChatColor.RED + "Invalid mob type or coordinates! Please enter a valid mob type and numbers.");
                    }
                } else {
                    player.sendMessage(ChatColor.RED + "Usage: /summonfriendlymob <mob_type> [<x> <y> <z>]");
                }
            } else {
                sender.sendMessage(ChatColor.RED + "This command can only be used by players.");
            }
            return true;
        }

        private double parseCoordinate(String input, double current) {
            if (input.startsWith("~")) {
                if (input.length() == 1) {
                    return current;
                }
                return current + Double.parseDouble(input.substring(1));
            }
            return Double.parseDouble(input);
        }

        public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
            if (args.length == 1) {
                ArrayList<String> mobs = new ArrayList<String>();
                for (EntityType entityType : EntityType.values()) {
                    if (entityType.getEntityClass() == null || !LivingEntity.class.isAssignableFrom(entityType.getEntityClass()) || entityType == EntityType.PLAYER) continue;
                    mobs.add(entityType.name().toLowerCase());
                }
                return mobs;
            }
            if (args.length == 2) {
                return Collections.singletonList("~ ~ ~");
            }
            return Collections.emptyList();
        }
    }

    public class GiveSpecialSpawnEggCommand
    implements CommandExecutor,
    TabCompleter {
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (args.length >= 2) {
                List targetPlayers = Bukkit.selectEntities((CommandSender)sender, (String)args[0]).stream().filter(entity -> entity instanceof Player).map(entity -> (Player)entity).collect(Collectors.toList());
                if (targetPlayers.isEmpty()) {
                    sender.sendMessage(ChatColor.RED + "No valid players found!");
                    return true;
                }
                try {
                    EntityType entityType = EntityType.valueOf((String)args[1].toUpperCase());
                    Material spawnEggMaterial = SummonFriendlyMob.this.getSpawnEggMaterial(entityType);
                    int amount = 1;
                    if (args.length == 3) {
                        amount = Integer.parseInt(args[2]);
                    }
                    ItemStack spawnEgg = new ItemStack(spawnEggMaterial, amount);
                    ItemMeta meta = spawnEgg.getItemMeta();
                    meta.setDisplayName("Special " + entityType.name() + " Spawn Egg");
                    meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)SummonFriendlyMob.this, "specialSpawnEgg"), PersistentDataType.STRING, (Object)entityType.name());
                    spawnEgg.setItemMeta(meta);
                    for (Player targetPlayer : targetPlayers) {
                        targetPlayer.getInventory().addItem(new ItemStack[]{spawnEgg});
                        sender.sendMessage(ChatColor.GREEN + "Given " + amount + " special spawn egg(s) for " + entityType.name() + " to " + targetPlayer.getName());
                    }
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage(ChatColor.RED + "Invalid mob type!");
                }
            } else {
                sender.sendMessage(ChatColor.RED + "Usage: /givespecialspawnegg <player> <mob> [amount]");
            }
            return true;
        }

        public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
            if (args.length == 1) {
                ArrayList<String> suggestions = new ArrayList<String>(Arrays.asList("@a", "@s", "@p", "@r"));
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    suggestions.add(onlinePlayer.getName());
                }
                return suggestions;
            }
            if (args.length == 2) {
                ArrayList<String> mobs = new ArrayList<String>();
                for (EntityType entityType : EntityType.values()) {
                    if (entityType.getEntityClass() == null || !LivingEntity.class.isAssignableFrom(entityType.getEntityClass()) || entityType == EntityType.PLAYER) continue;
                    mobs.add(entityType.name().toLowerCase());
                }
                return mobs;
            }
            if (args.length == 3) {
                return Collections.singletonList("1");
            }
            return Collections.emptyList();
        }
    }

    public class AttackCommand
    implements CommandExecutor,
    TabCompleter {
        private final Map<UUID, UUID> summonerMap;

        public AttackCommand(Map<UUID, UUID> summonerMap) {
            this.summonerMap = summonerMap;
        }

        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (SummonFriendlyMob.this.AllowAttack) {
                if (args.length != 1) {
                    sender.sendMessage(ChatColor.RED + "Usage: /attack <targetPlayer|targetMobUUID>");
                    return false;
                }
                Entity targetEntity = this.getTargetEntity(args[0]);
                if (targetEntity == null) {
                    sender.sendMessage(ChatColor.RED + "Target '" + args[0] + "' not found.");
                    return false;
                }
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ChatColor.RED + "Only players can use this command.");
                    return false;
                }
                Player summoner = (Player)sender;
                UUID summonerUUID = summoner.getUniqueId();
                boolean mobFound = false;
                for (Map.Entry<UUID, UUID> entry : this.summonerMap.entrySet()) {
                    Entity entity;
                    UUID mobUUID = entry.getKey();
                    UUID ownerUUID = entry.getValue();
                    if (!ownerUUID.equals(summonerUUID) || !((entity = Bukkit.getEntity((UUID)mobUUID)) instanceof Mob) || entity.isDead()) continue;
                    Mob hostileMob = (Mob)entity;
                    hostileMob.setTarget((LivingEntity)targetEntity);
                    mobFound = true;
                }
                if (mobFound) {
                    summoner.sendMessage(ChatColor.GREEN + "Your mobs are now attacking " + targetEntity.getName() + "!");
                } else {
                    summoner.sendMessage(ChatColor.RED + "You don't have any mobs to attack.");
                }
                return true;
            }
            sender.sendMessage(ChatColor.RED + "This command is disabled in config.yml");
            return true;
        }

        private Entity getTargetEntity(String input) {
            Player player = Bukkit.getPlayer((String)input);
            if (player != null) {
                return player;
            }
            try {
                UUID mobUUID = UUID.fromString(input);
                return Bukkit.getEntity((UUID)mobUUID);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
            if (args.length == 1 && sender instanceof Player) {
                Player player = (Player)sender;
                ArrayList<String> suggestions = new ArrayList<String>();
                Bukkit.getOnlinePlayers().forEach(p -> suggestions.add(p.getName()));
                Entity target = this.getEntityPlayerIsLookingAt(player);
                if (target != null && !(target instanceof Player)) {
                    suggestions.add(target.getUniqueId().toString());
                }
                return suggestions;
            }
            return Collections.emptyList();
        }

        private Entity getEntityPlayerIsLookingAt(Player player) {
            Location eyeLocation = player.getEyeLocation();
            Vector direction = eyeLocation.getDirection();
            double range = 10.0;
            RayTraceResult result = player.getWorld().rayTrace(eyeLocation, direction, range, FluidCollisionMode.NEVER, true, 0.5, entity -> entity != player);
            if (result != null && result.getHitEntity() != null) {
                return result.getHitEntity();
            }
            return null;
        }
    }

    public class MobsCommand
    implements CommandExecutor,
    TabCompleter {
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                UUID playerUUID = player.getUniqueId();
                ArrayList<String> mobList = new ArrayList<String>();
                for (Map.Entry entry : SummonFriendlyMob.this.summonerMap.entrySet()) {
                    Entity mob;
                    if (!((UUID)entry.getValue()).equals(playerUUID) || (mob = Bukkit.getEntity((UUID)((UUID)entry.getKey()))) == null) continue;
                    mobList.add(mob.getType() + " (UUID: " + mob.getUniqueId() + ")");
                }
                if (mobList.isEmpty()) {
                    player.sendMessage(ChatColor.RED + "You have no friendly mobs alive.");
                } else {
                    player.sendMessage(ChatColor.GREEN + "Your friendly mobs:");
                    for (String mobInfo : mobList) {
                        player.sendMessage(ChatColor.YELLOW + mobInfo);
                    }
                }
            } else {
                sender.sendMessage(ChatColor.RED + "This command can only be used by players.");
            }
            return true;
        }

        public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
            return Collections.emptyList();
        }
    }

    public class ReloadCommand
    implements CommandExecutor,
    TabCompleter {
        private final JavaPlugin plugin;

        public ReloadCommand(JavaPlugin plugin) {
            this.plugin = plugin;
        }

        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            try {
                if (SummonFriendlyMob.this.SaveFriendliness) {
                    SummonFriendlyMob.this.saveSummonerMap();
                }
                this.plugin.reloadConfig();
                File configFile = new File(SummonFriendlyMob.this.sfmfolder, "config.yml");
                SummonFriendlyMob.this.config = (FileConfiguration)YamlConfiguration.loadConfiguration((File)configFile);
                SummonFriendlyMob.this.UniversallyFriendly = SummonFriendlyMob.this.config.getBoolean("UniversallyFriendly", false);
                SummonFriendlyMob.this.SaveFriendliness = SummonFriendlyMob.this.config.getBoolean("SaveFriendliness", false);
                SummonFriendlyMob.this.UpdateNotifier = SummonFriendlyMob.this.config.getBoolean("UpdateNotifier", true);
                SummonFriendlyMob.this.AllowAttack = SummonFriendlyMob.this.config.getBoolean("AllowAttack", true);
                SummonFriendlyMob.this.AllowCustomMobSettings = SummonFriendlyMob.this.config.getBoolean("AllowCustomMobSettings", false);
                if (SummonFriendlyMob.this.SaveFriendliness) {
                    SummonFriendlyMob.this.loadSummonerMap();
                }
                if (SummonFriendlyMob.this.UpdateNotifier) {
                    SummonFriendlyMob.this.checkForUpdates();
                }
                if (SummonFriendlyMob.this.AllowCustomMobSettings) {
                    SummonFriendlyMob.this.createMobConfig();
                }
                sender.sendMessage(ChatColor.GREEN + "SummonFriendlyMob plugin reloaded successfully!");
            }
            catch (Exception e) {
                sender.sendMessage(ChatColor.RED + "An error occurred while reloading the plugin. Report this to armyfury in https://discord.gg/aEc7yqecYn.");
                this.plugin.getLogger().severe("Error reloading SummonFriendlyMob plugin. Report this to armyfury in https://discord.gg/aEc7yqecYn" + e.getMessage());
                e.printStackTrace();
            }
            return true;
        }

        public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
            return Collections.emptyList();
        }
    }
}

