/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ninesolsparry.network;

import java.util.function.Supplier;
import net.mcreator.ninesolsparry.NineSolsParryMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class NineSolsParryModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        NineSolsParryMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.isParrying = message.data.isParrying;
                    variables.isUnbound = message.data.isUnbound;
                    variables.unboundTimer = message.data.unboundTimer;
                    variables.parryCooldown = message.data.parryCooldown;
                    variables.parryCount = message.data.parryCount;
                    variables.internalDamage = message.data.internalDamage;
                    variables.internalDamageCooldown = message.data.internalDamageCooldown;
                    variables.internalDamageWait = message.data.internalDamageWait;
                    variables.unboundRelease = message.data.unboundRelease;
                    variables.unboundPrepare = message.data.unboundPrepare;
                    variables.showInternal = message.data.showInternal;
                    variables.repeatUnbound = message.data.repeatUnbound;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean isParrying = false;
        public boolean isUnbound = false;
        public double unboundTimer = 0.0;
        public double parryCooldown = 0.0;
        public double parryCount = 1.0;
        public double internalDamage = 0.0;
        public double internalDamageCooldown = 0.0;
        public double internalDamageWait = 0.0;
        public boolean unboundRelease = false;
        public double unboundPrepare = 0.0;
        public boolean showInternal = false;
        public boolean repeatUnbound = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                NineSolsParryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("isParrying", this.isParrying);
            nbt.m_128379_("isUnbound", this.isUnbound);
            nbt.m_128347_("unboundTimer", this.unboundTimer);
            nbt.m_128347_("parryCooldown", this.parryCooldown);
            nbt.m_128347_("parryCount", this.parryCount);
            nbt.m_128347_("internalDamage", this.internalDamage);
            nbt.m_128347_("internalDamageCooldown", this.internalDamageCooldown);
            nbt.m_128347_("internalDamageWait", this.internalDamageWait);
            nbt.m_128379_("unboundRelease", this.unboundRelease);
            nbt.m_128347_("unboundPrepare", this.unboundPrepare);
            nbt.m_128379_("showInternal", this.showInternal);
            nbt.m_128379_("repeatUnbound", this.repeatUnbound);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.isParrying = nbt.m_128471_("isParrying");
            this.isUnbound = nbt.m_128471_("isUnbound");
            this.unboundTimer = nbt.m_128459_("unboundTimer");
            this.parryCooldown = nbt.m_128459_("parryCooldown");
            this.parryCount = nbt.m_128459_("parryCount");
            this.internalDamage = nbt.m_128459_("internalDamage");
            this.internalDamageCooldown = nbt.m_128459_("internalDamageCooldown");
            this.internalDamageWait = nbt.m_128459_("internalDamageWait");
            this.unboundRelease = nbt.m_128471_("unboundRelease");
            this.unboundPrepare = nbt.m_128459_("unboundPrepare");
            this.showInternal = nbt.m_128471_("showInternal");
            this.repeatUnbound = nbt.m_128471_("repeatUnbound");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("nine_sols_parry", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.showInternal = original.showInternal;
            if (!event.isWasDeath()) {
                clone.isParrying = original.isParrying;
                clone.isUnbound = original.isUnbound;
                clone.unboundTimer = original.unboundTimer;
                clone.parryCooldown = original.parryCooldown;
                clone.parryCount = original.parryCount;
                clone.internalDamage = original.internalDamage;
                clone.internalDamageCooldown = original.internalDamageCooldown;
                clone.internalDamageWait = original.internalDamageWait;
                clone.unboundRelease = original.unboundRelease;
                clone.unboundPrepare = original.unboundPrepare;
                clone.repeatUnbound = original.repeatUnbound;
            }
        }
    }
}

