/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Map;
import me.wesley1808.servercore.common.config.Config;
import me.wesley1808.servercore.common.config.data.CommandConfig;
import me.wesley1808.servercore.common.dynamic.DynamicManager;
import me.wesley1808.servercore.common.services.Formatter;
import me.wesley1808.servercore.common.services.Permission;
import me.wesley1808.servercore.common.utils.Util;
import me.wesley1808.servercore.common.utils.statistics.GroupBy;
import me.wesley1808.servercore.common.utils.statistics.StatisticType;
import me.wesley1808.servercore.common.utils.statistics.Statistics;
import me.wesley1808.servercore.common.utils.statistics.entry.StatisticEntry;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5562;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class StatisticsCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder statistics = (LiteralArgumentBuilder)class_2170.method_9247((String)"statistics").requires(Permission.require("command.statistics", 2));
        statistics.executes(ctx -> StatisticsCommand.displayOverview((class_2168)ctx.getSource()));
        for (StatisticType type : StatisticType.values()) {
            statistics.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)type.getCommandFormat()).executes(ctx -> StatisticsCommand.display((CommandContext<class_2168>)ctx, type, 1))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<class_2168>)ctx, type, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"byType").executes(ctx -> StatisticsCommand.display((CommandContext<class_2168>)ctx, type, GroupBy.TYPE, 1))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<class_2168>)ctx, type, GroupBy.TYPE, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> StatisticsCommand.display((CommandContext<class_2168>)ctx, type, 1, class_2186.method_9315((CommandContext)ctx, (String)"player")))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<class_2168>)ctx, type, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"), class_2186.method_9315((CommandContext)ctx, (String)"player"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"byPlayer").executes(ctx -> StatisticsCommand.display((CommandContext<class_2168>)ctx, type, GroupBy.PLAYER, 1))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<class_2168>)ctx, type, GroupBy.PLAYER, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))));
        }
        dispatcher.register(statistics);
    }

    private static int displayOverview(class_2168 source) {
        Statistics statistics = Statistics.getInstance(source.method_9211());
        CommandConfig config = Config.get().commands();
        source.method_9226(() -> {
            class_5250 component = class_2561.method_43473();
            class_5250 title = class_2561.method_43470((String)"Statistics").method_54663(config.tertiaryValue());
            if (source.method_43737()) {
                Formatter.addLines(component, 16, config.primaryValue(), (class_2561)title);
            } else {
                component.method_10852((class_2561)title);
            }
            double mspt = DynamicManager.getInstance(source.method_9211()).getAverageTickTime();
            double tps = mspt != 0.0 ? Math.min(1000.0 / mspt, 20.0) : 20.0;
            component.method_10852(Formatter.parse("\n<dark_gray>\u00bb <c:#primary>TPS: <c:#secondary>%.2f</c> - MSPT: <c:#secondary>%.2f".formatted(tps, mspt), source.method_9211()));
            component.method_10852(Formatter.parse("\n<dark_gray>\u00bb <c:#primary>Total chunk count: <c:#secondary>%d".formatted(statistics.getChunkCount(true)), source.method_9211()));
            component.method_10852(Formatter.parse("\n<dark_gray>\u00bb <c:#primary>Total entity count: <c:#secondary>%d".formatted(statistics.getAllEntities().size()), source.method_9211()));
            component.method_10852(Formatter.parse("\n<dark_gray>\u00bb <c:#primary>Total block entity count: <c:#secondary>%d".formatted(statistics.getAllBlockEntities().size()), source.method_9211()));
            return component;
        }, false);
        return 1;
    }

    private static int display(CommandContext<class_2168> context, StatisticType type, int page) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player != null) {
            return StatisticsCommand.display(context, type, GroupBy.TYPE, page, player);
        }
        return StatisticsCommand.display(context, type, GroupBy.TYPE, page);
    }

    private static int display(CommandContext<class_2168> context, StatisticType type, GroupBy groupBy, int page) {
        return StatisticsCommand.display(context, type, groupBy, page, null);
    }

    private static int display(CommandContext<class_2168> context, StatisticType type, int page, @Nullable class_3222 player) {
        return StatisticsCommand.display(context, type, GroupBy.TYPE, page, player);
    }

    private static int display(CommandContext<class_2168> context, StatisticType type, GroupBy groupBy, int page, @Nullable class_3222 player) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case StatisticType.ENTITY -> StatisticsCommand.displayEntities(context, groupBy, page, player);
            case StatisticType.BLOCK_ENTITY -> StatisticsCommand.displayBlockEntities(context, groupBy, page, player);
        };
    }

    private static int displayEntities(CommandContext<class_2168> context, GroupBy groupBy, int page, @Nullable class_3222 player) {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        Statistics statistics = Statistics.getInstance(server);
        Map<String, StatisticEntry<class_1297>> map = groupBy == GroupBy.PLAYER ? statistics.getEntitiesByPlayer(server.method_3760().method_14571()) : statistics.getEntitiesByType(player == null ? statistics.getAllEntities() : statistics.getEntitiesNear(player));
        StatisticsCommand.displayFeedback(context, Util.sortByValue(map), StatisticType.ENTITY, groupBy, page, player);
        return 1;
    }

    private static int displayBlockEntities(CommandContext<class_2168> context, GroupBy groupBy, int page, @Nullable class_3222 player) {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        Statistics statistics = Statistics.getInstance(server);
        Map<String, StatisticEntry<class_5562>> map = groupBy == GroupBy.PLAYER ? statistics.getBlockEntitiesByPlayer(server.method_3760().method_14571()) : statistics.getBlockEntitiesByType(player == null ? statistics.getAllBlockEntities() : statistics.getBlockEntitiesNear(player));
        StatisticsCommand.displayFeedback(context, Util.sortByValue(map), StatisticType.BLOCK_ENTITY, groupBy, page, player);
        return 1;
    }

    private static <T> void displayFeedback(CommandContext<class_2168> context, List<Map.Entry<String, StatisticEntry<T>>> formattedEntries, StatisticType type, GroupBy groupBy, int page, @Nullable class_3222 player) {
        class_2168 source = (class_2168)context.getSource();
        class_5250 component = class_2561.method_43473();
        CommandConfig config = Config.get().commands();
        component.method_10852(StatisticsCommand.createHeader(type, groupBy, source, player, config));
        boolean success = Util.iteratePage(formattedEntries, page, 8, (entry, index) -> component.method_10852(StatisticsCommand.createEntry(source, entry, index, type, groupBy)));
        if (success) {
            source.method_9226(() -> component.method_10852(StatisticsCommand.createFooter(source, page, Util.getPage(formattedEntries.size(), 8), type, context, config)), false);
        } else if (page == 1) {
            source.method_9213((class_2561)class_2561.method_43470((String)String.format("No %s were found!", type.getName().toLowerCase())));
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"Page doesn't exist!"));
        }
    }

    private static <T> class_2561 createEntry(class_2168 source, Map.Entry<String, StatisticEntry<T>> entry, int index, StatisticType type, GroupBy groupBy) {
        class_5250 component = class_2561.method_43473();
        component.method_10852(Formatter.parse("\n<c:#secondary>%d. <c:#primary>%s %s".formatted(index, entry.getKey(), entry.getValue().formatValue()), source.method_9211()));
        if (groupBy == GroupBy.PLAYER) {
            component.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/statistics %s byType %s".formatted(type.getCommandFormat(), entry.getKey()))));
        }
        return component;
    }

    private static class_2561 createHeader(StatisticType type, GroupBy groupBy, class_2168 source, class_3222 player, CommandConfig config) {
        class_5250 component = class_2561.method_43473();
        class_2561 title = player == null ? Formatter.parse("<c:#primary><c:#tertiary>%s</c> by <c:#tertiary>%s".formatted(type.getName(), groupBy.getName()), source.method_9211()) : Formatter.parse("<c:#primary><c:#tertiary>%s</c> for <c:#tertiary>%s".formatted(type.getName(), player.method_5820()), source.method_9211());
        if (source.method_43737()) {
            Formatter.addLines(component, 16, config.primaryValue(), title);
        } else {
            component.method_10852(title);
        }
        return component;
    }

    private static class_2561 createFooter(class_2168 source, int page, int pageCount, StatisticType type, CommandContext<class_2168> context, CommandConfig config) {
        class_5250 component = class_2561.method_43470((String)"\n");
        class_5250 footer = class_2561.method_43473();
        String command = StatisticsCommand.parseCommand(context.getInput());
        class_5250 prevPage = class_2561.method_43470((String)"<<").method_54663(config.secondaryValue());
        if (page > 1) {
            prevPage.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609(command.replace("%page_nr%", String.valueOf(page - 1)))));
        }
        class_5250 nextPage = class_2561.method_43470((String)">>").method_54663(config.secondaryValue());
        nextPage.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609(command.replace("%page_nr%", String.valueOf(page + 1)))));
        footer.method_10852((class_2561)prevPage);
        footer.method_10852(Formatter.parse(" <c:#primary>Page <c:#tertiary>%d</c> of <c:#tertiary>%d ".formatted(page, pageCount), source.method_9211()));
        footer.method_10852((class_2561)nextPage);
        if (((class_2168)context.getSource()).method_43737()) {
            Formatter.addLines(component, type == StatisticType.BLOCK_ENTITY ? 20 : 16, config.primaryValue(), (class_2561)footer);
        } else {
            component.method_10852((class_2561)footer);
        }
        return component;
    }

    private static String parseCommand(String input) {
        Object command = input.replaceAll("\\b\\d+\\b", "%page_nr%");
        if (!((String)command).contains("%page_nr%")) {
            command = (String)command + " %page_nr%";
        }
        return "/" + (String)command;
    }
}

