/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.mixin.features.activation_range;

import java.util.Set;
import me.wesley1808.servercore.common.activation_range.ActivationRange;
import me.wesley1808.servercore.common.config.data.activation_range.ActivationType;
import me.wesley1808.servercore.common.interfaces.activation_range.ActivationEntity;
import me.wesley1808.servercore.common.interfaces.activation_range.Inactive;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public class EntityMixin
implements Inactive,
ActivationEntity {
    @Shadow
    @Final
    private Set<String> field_6029;
    @Shadow
    private class_1937 field_6002;
    @Unique
    private int servercore$activatedTick;
    @Unique
    private int servercore$activatedImmunityTick;
    @Unique
    private boolean servercore$isInactive = false;
    @Unique
    private ActivationType servercore$activationType;
    @Unique
    private boolean servercore$excluded = false;
    @Unique
    private int servercore$fullTickCount;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void servercore$setupActivationStates(class_1299<?> type, class_1937 level, CallbackInfo ci) {
        class_1297 entity = (class_1297)this;
        this.servercore$activationType = ActivationRange.initializeEntityActivationType(entity);
        this.servercore$excluded = level == null || ActivationRange.isExcluded(entity);
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;limitPistonMovement(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", shift=At.Shift.BEFORE)})
    public void servercore$onPistonMove(class_1313 moverType, class_243 vec3, CallbackInfo ci) {
        MinecraftServer server = this.field_6002.method_8503();
        if (server != null) {
            int ticks = server.method_3780() + 20;
            this.servercore$activatedTick = Math.max(this.servercore$activatedTick, ticks);
            this.servercore$activatedImmunityTick = Math.max(this.servercore$activatedImmunityTick, ticks);
        }
    }

    @Inject(method={"push(DDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void servercore$ignorePushingWhileInactive(double x, double y, double z, CallbackInfo ci) {
        if (this.servercore$isInactive && !this.field_6002.method_8608()) {
            ci.cancel();
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private void servercore$onLoadNbt(CallbackInfo ci) {
        this.servercore$excluded |= this.field_6029.contains("exclude_ear");
    }

    @Inject(method={"addTag"}, at={@At(value="HEAD")})
    private void servercore$onTagAdded(String tag, CallbackInfoReturnable<Boolean> cir) {
        this.servercore$excluded |= tag.equals("exclude_ear");
    }

    @Override
    public ActivationType servercore$getActivationType() {
        return this.servercore$activationType;
    }

    @Override
    public boolean servercore$isExcluded() {
        return this.servercore$excluded;
    }

    @Override
    public int servercore$getActivatedTick() {
        return this.servercore$activatedTick;
    }

    @Override
    public void servercore$setActivatedTick(int tick) {
        this.servercore$activatedTick = tick;
    }

    @Override
    public int servercore$getActivatedImmunityTick() {
        return this.servercore$activatedImmunityTick;
    }

    @Override
    public void servercore$setActivatedImmunityTick(int tick) {
        this.servercore$activatedImmunityTick = tick;
    }

    @Override
    public boolean servercore$isInactive() {
        return this.servercore$isInactive;
    }

    @Override
    public void servercore$setInactive(boolean inactive) {
        this.servercore$isInactive = inactive;
    }

    @Override
    public int servercore$getFullTickCount() {
        return this.servercore$fullTickCount;
    }

    @Override
    public void servercore$incFullTickCount() {
        ++this.servercore$fullTickCount;
    }

    @Override
    public void servercore$inactiveTick() {
    }
}

