/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.letmedespawn;

import com.frikinjay.almanac.Almanac;
import com.frikinjay.letmedespawn.command.LetMeDespawnCommands;
import com.frikinjay.letmedespawn.config.LetMeDespawnConfig;
import com.mojang.logging.LogUtils;
import java.io.File;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public final class LetMeDespawn {
    public static final String MOD_ID = "letmedespawn";
    public static final Logger logger = LogUtils.getLogger();
    public static final File CONFIG_FILE = new File("config/letmedespawn.json");
    public static LetMeDespawnConfig config;
    private static Registry<Item> cachedItemRegistry;
    private static Registry<EntityType<?>> cachedMobRegistry;

    public static void init() {
        config = LetMeDespawnConfig.load();
        Almanac.addConfigChangeListener((File)CONFIG_FILE, newConfig -> {
            config = (LetMeDespawnConfig)newConfig;
            logger.info("LetMeDespawn config reloaded");
        });
        config.save();
        Almanac.addCommandRegistration(LetMeDespawnCommands::register);
    }

    public static Registry<Item> getItemRegistry(Level level) {
        if (cachedItemRegistry == null && level != null) {
            cachedItemRegistry = level.registryAccess().lookupOrThrow(Registries.ITEM);
        }
        return cachedItemRegistry;
    }

    public static String getItemKey(ItemStack itemStack, Mob entity) {
        Registry<Item> itemRegistry;
        ResourceLocation itemId = null;
        if (!itemStack.isEmpty() && (itemRegistry = LetMeDespawn.getItemRegistry(entity.level())) != null) {
            itemId = itemRegistry.getKey((Object)itemStack.getItem());
        }
        return itemId != null ? itemId.toString() : "";
    }

    public static Registry<EntityType<?>> getMobRegistry(Level level) {
        if (cachedMobRegistry == null && level != null) {
            cachedMobRegistry = level.registryAccess().lookupOrThrow(Registries.ENTITY_TYPE);
        }
        return cachedMobRegistry;
    }

    public static String getMobKey(Mob entity) {
        ResourceLocation mobId = null;
        Registry<EntityType<?>> mobRegistry = LetMeDespawn.getMobRegistry(entity.level());
        if (mobRegistry != null) {
            mobId = mobRegistry.getKey((Object)entity.getType());
        }
        return mobId != null ? mobId.toString() : "";
    }

    public static void clearRegistryCache() {
        cachedItemRegistry = null;
        cachedMobRegistry = null;
    }

    public static void setPersistence(Mob entity, EquipmentSlot slot) {
        ItemStack itemStack = entity.getItemBySlot(slot);
        CustomData component = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        CompoundTag nbt = component != null ? component.copyTag() : new CompoundTag();
        nbt.putBoolean("picked", true);
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
        Almanac.pickedItems = true;
        entity.persistenceRequired = config.getMobNames().contains(LetMeDespawn.getMobKey(entity)) || !LetMeDespawn.hasDespawnableName(entity);
    }

    public static boolean hasDespawnableName(Mob entity) {
        if (entity.hasCustomName()) {
            return Almanac.matchesStackedName((String)entity.getCustomName().getString(), (Entity)entity);
        }
        return true;
    }

    static {
        cachedItemRegistry = null;
        cachedMobRegistry = null;
    }
}

