/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.mod.krypton_fnp.mixin.network.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ByteProcessor;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.Varint21FrameDecoder;
import one.pkg.mod.krypton_fnp.shared.ModConfig;
import one.pkg.mod.krypton_fnp.shared.network.util.VarIntUtil;
import one.pkg.mod.krypton_fnp.shared.network.util.WellKnownExceptions;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Varint21FrameDecoder.class})
public class Varint21FrameDecoderMixin {
    @Unique
    private final ExecutorService krypton_FNP$executor = Executors.newSingleThreadExecutor(Thread.ofVirtual().factory());
    @Final
    @Shadow
    private BandwidthDebugMonitor monitor;

    @Unique
    private static int krypton_fnp$readRawVarInt21(ByteBuf buffer) {
        if (buffer.readableBytes() < 4) {
            return Varint21FrameDecoderMixin.krypton_fnp$readRawVarintSmallBuf(buffer);
        }
        int wholeOrMore = buffer.getIntLE(buffer.readerIndex());
        int atStop = ~wholeOrMore & 0x808080;
        if (atStop == 0) {
            if (ModConfig.Compatibility.AllowWideVarInt()) {
                return Varint21FrameDecoderMixin.krypton_fnp$readRawVarintSmallBuf(buffer);
            }
            throw WellKnownExceptions.VARINT_BIG_CACHED;
        }
        int bitsToKeep = Integer.numberOfTrailingZeros(atStop) + 1;
        buffer.skipBytes(bitsToKeep >> 3);
        int preservedBytes = wholeOrMore & (atStop ^ atStop - 1);
        preservedBytes = preservedBytes & 0x7F007F | (preservedBytes & 0x7F00) >> 1;
        preservedBytes = preservedBytes & 0x3FFF | (preservedBytes & 0x3FFF0000) >> 2;
        return preservedBytes;
    }

    @Unique
    private static int krypton_fnp$readRawVarintSmallBuf(ByteBuf buffer) {
        if (!buffer.isReadable()) {
            return 0;
        }
        buffer.markReaderIndex();
        byte tmp = buffer.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        if (!buffer.isReadable()) {
            buffer.resetReaderIndex();
            return 0;
        }
        tmp = buffer.readByte();
        if (tmp >= 0) {
            return result | tmp << 7;
        }
        result |= (tmp & 0x7F) << 7;
        if (!buffer.isReadable()) {
            buffer.resetReaderIndex();
            return 0;
        }
        tmp = buffer.readByte();
        if (tmp >= 0) {
            return result | tmp << 14;
        }
        return result | (tmp & 0x7F) << 14;
    }

    @Overwrite
    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!ctx.channel().isActive()) {
            in.clear();
            return;
        }
        int packetStart = in.forEachByte(ByteProcessor.FIND_NON_NUL);
        if (packetStart == -1) {
            in.clear();
            return;
        }
        in.readerIndex(packetStart);
        in.markReaderIndex();
        int preIndex = in.readerIndex();
        int length = Varint21FrameDecoderMixin.krypton_fnp$readRawVarInt21(in);
        if (preIndex == in.readerIndex()) {
            return;
        }
        if (length < 0) {
            throw WellKnownExceptions.BAD_LENGTH_CACHED;
        }
        if (length > 0) {
            if (in.readableBytes() < length) {
                in.resetReaderIndex();
            } else {
                if (ModConfig.Fix.Issues128.isEnabled() && this.monitor != null) {
                    this.krypton_FNP$execute(length);
                }
                out.add(in.readRetainedSlice(length));
            }
        }
    }

    @Unique
    private void krypton_FNP$execute(int l) {
        if (ModConfig.Fix.Issues128.isSync()) {
            this.monitor.onReceive(l + VarIntUtil.getVarIntLength(l));
        } else {
            this.krypton_FNP$executor.execute(() -> this.monitor.onReceive(l + VarIntUtil.getVarIntLength(l)));
        }
    }
}

