/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.mod.krypton_fnp.shared;

import java.nio.file.Path;
import one.pkg.config.SewliaConfig;
import one.pkg.config.annotation.config.ConfigEntry;
import one.pkg.config.annotation.config.ConfigTarget;
import one.pkg.config.annotation.loader.ReadWith;
import one.pkg.config.metadata.ConfigMeta;
import one.pkg.config.metadata.DumpMeta;
import one.pkg.loader.Loader;

@ConfigEntry(value="krypton_fnp")
public class ModConfig {
    public static final SewliaConfig config;
    @ConfigTarget(group={"compress"}, value="compressionLevel", comment="The compression level for packets, between 1-9.")
    private static int var1;
    @ConfigTarget(group={"compress"}, value="permitOversizedPackets", comment="Permit Oversized Packets")
    private static boolean var2;
    @ConfigTarget(group={"compress.blending-mode"}, value="enabled", comment="(Experimental) Delegate data packets with poor performance in the Native implementation to the Java implementation")
    private static boolean var3;
    @ConfigTarget(group={"compress.blending-mode"}, value="linux-fallback-min-size")
    private static int var4;
    @ConfigTarget(group={"compress.blending-mode"}, value="repetitive-threshold")
    private static double var5;
    @ConfigTarget(group={"fix.issues128"}, value="enabled", comment="Fix Traffic Statistics")
    private static boolean var6;
    @ConfigTarget(group={"fix.issues128"}, value="sync", comment="Run bandwidth statistics on sync thread, which is closer to Vanilla behavior.")
    private static boolean var7;
    @ConfigTarget(group={"compatibility"}, value="allow-wide-var-int")
    private static boolean var8;
    @ConfigTarget(group={"mixin"}, value="loginVT", comment="Replace player login validation thread with virtual thread")
    private static boolean var9;
    @ConfigTarget(group={"mixin"}, value="textFilterVT", comment="Replace text filter thread with virtual thread")
    private static boolean var10;
    @ConfigTarget(group={"mixin"}, value="utilVT", comment="Replace download thread with virtual thread")
    private static boolean var11;
    @ConfigTarget(group={"mixin"}, value="bestVarLong", comment="Optimized VarLong implementation")
    private static boolean var12;
    @ConfigTarget(group={"netty"}, value="allocatorMaxOrder", comment="Change Netty's default 16MiB memory allocation to 4MiB, as Minecraft has a 2MiB packet size limit.")
    private static int var13;

    private ModConfig() {
    }

    @ReadWith(value="var1")
    private static void setCompressionLevel(DumpMeta dumpMeta) {
        int level;
        if (!(dumpMeta.getObject() instanceof Integer)) {
            dumpMeta.setCancelled(true);
        }
        if ((level = ((Integer)dumpMeta.getObject()).intValue()) > 9 || level < 1) {
            dumpMeta.setObject((Object)4);
            dumpMeta.setCancelled(true);
        }
    }

    @ReadWith(value="var12")
    private static void setAllocatorMaxOrder(DumpMeta dumpMeta) {
        int level;
        if (!(dumpMeta.getObject() instanceof Integer)) {
            dumpMeta.setCancelled(true);
        }
        if ((level = ((Integer)dumpMeta.getObject()).intValue()) > 51 || level < 9) {
            dumpMeta.setObject((Object)9);
            dumpMeta.setCancelled(true);
        }
    }

    static {
        var1 = 4;
        var2 = false;
        var3 = false;
        var4 = 1024;
        var5 = 0.6;
        var6 = false;
        var7 = true;
        var8 = false;
        var9 = true;
        var10 = true;
        var11 = true;
        var12 = true;
        var13 = 9;
        config = new SewliaConfig(new ConfigMeta[]{ConfigMeta.of(ModConfig.class, (Path)Loader.INSTANCE.getConfigPath().resolve("krypton_fnp.yaml"))});
    }

    public static class Netty {
        public static int getAllocatorMaxOrder() {
            return var13;
        }
    }

    public static class Mixin {
        public static boolean isLoginVT() {
            return var9;
        }

        public static boolean isTextFilterVT() {
            return var10;
        }

        public static boolean isUtilVT() {
            return var11;
        }

        public static boolean isBestVarLong() {
            return var12;
        }
    }

    public static class Compatibility {
        public static boolean AllowWideVarInt() {
            return var8;
        }
    }

    public static class Fix {

        public static class Issues128 {
            public static boolean isEnabled() {
                return var6;
            }

            public static boolean isSync() {
                return var7;
            }
        }
    }

    public static class Compression {
        public static int getLevel() {
            return var1;
        }

        public static boolean isPermitOversizedPackets() {
            return var2;
        }

        public static class BlendingMode {
            public static boolean isEnabled() {
                return var3;
            }

            public static int getLinuxFallbackMinSize() {
                return var4;
            }

            public static double getRepetitiveThreshold() {
                return var5;
            }
        }
    }
}

