/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.aabb;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@Deprecated
public final class BoundingBoxMerger {
    private static final Long2ObjectMap<Direction> DIRECTION_LOOKUP = (Long2ObjectMap)Arrays.stream(Direction.values()).collect(Collectors.toMap(dir -> new BlockPos(dir.getUnitVec3i()).asLong(), dir -> dir, (a, b) -> {
        throw new IllegalStateException("Duplicate direction detected.");
    }, Long2ObjectOpenHashMap::new));
    private final Map<Vec3, AABB> positionToBox = new HashMap<Vec3, AABB>();
    private final Multimap<AABB, Vec3> boxToPosition = HashMultimap.create();
    private double xCoordTracker = Double.NEGATIVE_INFINITY;
    private double yCoordTracker = Double.NEGATIVE_INFINITY;
    private Vec3 currentCenter = null;
    private AABB currentBounds = null;

    public static Collection<AABB> merge(Collection<BlockPos> positions, BlockPos referencePoint) {
        BoundingBoxMerger boxMerger = new BoundingBoxMerger();
        positions.stream().map(pos -> pos.subtract((Vec3i)referencePoint)).sorted().map(AABB::new).forEachOrdered(box -> {
            Vec3 center;
            if (boxMerger.xCoordTracker != box.minX || boxMerger.yCoordTracker != box.minY) {
                boxMerger.currentBounds = null;
            }
            boxMerger.xCoordTracker = box.minX;
            boxMerger.yCoordTracker = box.minY;
            boxMerger.currentCenter = center = box.getCenter();
            if (boxMerger.currentBounds != null && boxMerger.canCombine(boxMerger.currentBounds, (AABB)box, center)) {
                return;
            }
            if (boxMerger.tryCombineAdjacent(center, (AABB)box)) {
                return;
            }
            boxMerger.currentBounds = box;
            boxMerger.positionToBox.put(center, (AABB)box);
            boxMerger.boxToPosition.put(box, (Object)center);
        });
        return boxMerger.boxToPosition.keySet();
    }

    private static boolean isAligned(AABB first, AABB second, Direction direction) {
        return BoundingBoxMerger.getAxisValue(first, direction) == BoundingBoxMerger.getAxisValue(second, direction.getOpposite()) && Arrays.stream(Direction.values()).filter(d -> d.getAxis() != direction.getAxis()).allMatch(d -> BoundingBoxMerger.getAxisValue(first, d) == BoundingBoxMerger.getAxisValue(second, d));
    }

    private static double getAxisValue(AABB box, Direction direction) {
        return direction.getAxisDirection() == Direction.AxisDirection.POSITIVE ? box.max(direction.getAxis()) : box.min(direction.getAxis());
    }

    private static Direction directionFromVector(Vec3 vector) {
        return (Direction)DIRECTION_LOOKUP.get(BlockPos.asLong((int)((int)vector.x), (int)((int)vector.y), (int)((int)vector.z)));
    }

    private boolean canCombine(AABB current, AABB neighbor, Vec3 center) {
        Direction direction = BoundingBoxMerger.directionFromVector(center.subtract(current.getCenter()));
        return direction != null && BoundingBoxMerger.isAligned(current, neighbor, direction) && this.mergeBoxes(current, neighbor, center);
    }

    private boolean tryCombineAdjacent(Vec3 center, AABB box) {
        for (Direction direction : Direction.values()) {
            Vec3 adjacentCenter = center.add(Vec3.atLowerCornerOf((Vec3i)direction.getUnitVec3i()));
            AABB adjacentBox = this.positionToBox.get(adjacentCenter);
            if (adjacentBox == null || !BoundingBoxMerger.isAligned(box, adjacentBox, direction)) continue;
            return this.mergeBoxes(adjacentBox, box, center);
        }
        return false;
    }

    private boolean mergeBoxes(AABB source, AABB target, Vec3 center) {
        AABB expanded = source.minmax(target);
        HashSet mergedPositions = new HashSet(this.boxToPosition.removeAll((Object)source));
        mergedPositions.forEach(v -> this.positionToBox.put((Vec3)v, expanded));
        this.boxToPosition.putAll((Object)expanded, mergedPositions);
        this.positionToBox.put(center, expanded);
        this.boxToPosition.put((Object)expanded, (Object)center);
        this.currentBounds = expanded;
        return true;
    }
}

