/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.event.v1.events.common;

import com.iamkaf.amber.api.event.v1.Event;
import com.iamkaf.amber.api.event.v1.EventFactory;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PlayerEvents {
    public static final Event<EntityInteract> ENTITY_INTERACT = EventFactory.createArrayBacked(EntityInteract.class, callbacks -> (player, world, hand, entity) -> {
        for (EntityInteract callback : callbacks) {
            InteractionResult result = callback.interact(player, world, hand, entity);
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    });
    public static final Event<PlayerJoin> PLAYER_JOIN = EventFactory.createArrayBacked(PlayerJoin.class, callbacks -> player -> {
        for (PlayerJoin callback : callbacks) {
            callback.onPlayerJoin(player);
        }
    });
    public static final Event<PlayerLeave> PLAYER_LEAVE = EventFactory.createArrayBacked(PlayerLeave.class, callbacks -> player -> {
        for (PlayerLeave callback : callbacks) {
            callback.onPlayerLeave(player);
        }
    });
    public static final Event<PlayerRespawn> PLAYER_RESPAWN = EventFactory.createArrayBacked(PlayerRespawn.class, callbacks -> (oldPlayer, newPlayer, alive) -> {
        for (PlayerRespawn callback : callbacks) {
            callback.onPlayerRespawn(oldPlayer, newPlayer, alive);
        }
    });

    @FunctionalInterface
    public static interface PlayerRespawn {
        public void onPlayerRespawn(ServerPlayer var1, ServerPlayer var2, boolean var3);
    }

    @FunctionalInterface
    public static interface PlayerLeave {
        public void onPlayerLeave(ServerPlayer var1);
    }

    @FunctionalInterface
    public static interface PlayerJoin {
        public void onPlayerJoin(ServerPlayer var1);
    }

    @FunctionalInterface
    public static interface EntityInteract {
        public InteractionResult interact(Player var1, Level var2, InteractionHand var3, Entity var4);
    }
}

