/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.networking.v1.examples;

import com.iamkaf.amber.Constants;
import com.iamkaf.amber.api.networking.v1.Packet;
import com.iamkaf.amber.api.networking.v1.PacketContext;
import net.minecraft.network.FriendlyByteBuf;

public record PongPacket(long originalTimestamp, long responseTimestamp, String message) implements Packet<PongPacket>
{
    public static void encode(PongPacket packet, FriendlyByteBuf buffer) {
        buffer.writeVarLong(packet.originalTimestamp);
        buffer.writeVarLong(packet.responseTimestamp);
        buffer.writeUtf(packet.message);
    }

    public static PongPacket decode(FriendlyByteBuf buffer) {
        long originalTimestamp = buffer.readVarLong();
        long responseTimestamp = buffer.readVarLong();
        String message = buffer.readUtf();
        return new PongPacket(originalTimestamp, responseTimestamp, message);
    }

    public static void handle(PongPacket packet, PacketContext context) {
        if (context.isServerSide()) {
            context.execute(() -> {
                long currentTime = System.currentTimeMillis();
                long totalRoundTrip = currentTime - packet.originalTimestamp;
                long clientProcessingTime = packet.responseTimestamp - packet.originalTimestamp;
                long networkLatency = totalRoundTrip - clientProcessingTime;
                Constants.LOG.info("Server received pong: {}", (Object)packet.message);
                Constants.LOG.info("  Total round-trip: {}ms", (Object)totalRoundTrip);
                Constants.LOG.info("  Client processing: {}ms", (Object)clientProcessingTime);
                Constants.LOG.info("  Network latency: {}ms", (Object)networkLatency);
                PongPacket.recordLatency(totalRoundTrip, networkLatency);
            });
        } else {
            Constants.LOG.error("Client received pong packet - this should not happen!");
        }
    }

    private static void recordLatency(long totalLatency, long networkLatency) {
        Constants.LOG.info("Recorded latency: {}ms", (Object)networkLatency);
    }
}

