/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.platform.v1;

import com.iamkaf.amber.api.platform.v1.ModInfo;
import com.iamkaf.amber.platform.Services;
import com.iamkaf.amber.util.Env;
import java.nio.file.Path;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class Platform {
    public static String getPlatformName() {
        return Services.PLATFORM.getPlatformName();
    }

    public static Path getGameFolder() {
        return Services.PLATFORM.getConfigDirectory().getParent();
    }

    public static Path getConfigFolder() {
        return Services.PLATFORM.getConfigDirectory();
    }

    public static Path getModsFolder() {
        return Platform.getGameFolder().resolve("mods");
    }

    public static Env getEnvironment() {
        return Services.PLATFORM.getEnvironment();
    }

    public static boolean isClient() {
        return Platform.getEnvironment() == Env.CLIENT;
    }

    public static boolean isServer() {
        return Platform.getEnvironment() == Env.SERVER;
    }

    public static String getPlatform() {
        return Platform.getPlatformName();
    }

    public static boolean isFabric() {
        return "Fabric".equalsIgnoreCase(Platform.getPlatformName());
    }

    public static boolean isForge() {
        return "Forge".equalsIgnoreCase(Platform.getPlatformName());
    }

    public static boolean isNeoForge() {
        return "NeoForge".equalsIgnoreCase(Platform.getPlatformName());
    }

    public static Path getLogsFolder() {
        return Platform.getGameFolder().resolve("logs");
    }

    public static Path getScreenshotsFolder() {
        return Platform.getGameFolder().resolve("screenshots");
    }

    public static Path getResourcePacksFolder() {
        return Platform.getGameFolder().resolve("resourcepacks");
    }

    public static Path getShaderPacksFolder() {
        return Platform.getGameFolder().resolve("shaderpacks");
    }

    public static boolean isModLoaded(String id) {
        return Services.PLATFORM.isModLoaded(id);
    }

    public static Collection<String> getModIds() {
        return Services.PLATFORM.getModIds();
    }

    public static boolean isDevelopmentEnvironment() {
        return Services.PLATFORM.isDevelopmentEnvironment();
    }

    @Nullable
    public static ModInfo getModInfo(String modId) {
        return Services.PLATFORM.getModInfo(modId);
    }

    @Nullable
    public static String getModVersion(String modId) {
        ModInfo modInfo = Platform.getModInfo(modId);
        return modInfo != null ? modInfo.version() : null;
    }

    @Nullable
    public static String getModName(String modId) {
        ModInfo modInfo = Platform.getModInfo(modId);
        return modInfo != null ? modInfo.name() : null;
    }

    public static boolean isAnyModLoaded(String ... modIds) {
        for (String modId : modIds) {
            if (!Platform.isModLoaded(modId)) continue;
            return true;
        }
        return false;
    }

    public static boolean areAllModsLoaded(String ... modIds) {
        for (String modId : modIds) {
            if (Platform.isModLoaded(modId)) continue;
            return false;
        }
        return true;
    }

    public static Path getSavesFolder() {
        return Platform.getGameFolder().resolve("saves");
    }
}

