/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.command;

import com.iamkaf.amber.AmberMod;
import com.iamkaf.amber.Constants;
import com.iamkaf.amber.api.commands.v1.SimpleCommands;
import com.iamkaf.amber.api.core.v2.AmberModInfo;
import com.iamkaf.amber.api.event.v1.events.common.CommandEvents;
import com.iamkaf.amber.api.platform.v1.ModInfo;
import com.iamkaf.amber.api.platform.v1.Platform;
import com.iamkaf.amber.networking.v1.AmberNetworking;
import com.iamkaf.amber.platform.Services;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public class AmberCommands {
    private static final LiteralArgumentBuilder<CommandSourceStack> PING_COMMAND = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ping").requires(source -> source.hasPermission(2))).executes(commandContext -> {
        ServerPlayer patt0$temp = ((CommandSourceStack)commandContext.getSource()).getPlayer();
        if (patt0$temp instanceof ServerPlayer) {
            ServerPlayer serverPlayer = patt0$temp;
            AmberNetworking.testConnectivity(serverPlayer);
            ((CommandSourceStack)commandContext.getSource()).sendSuccess(() -> Component.literal((String)"Sent ping to test connectivity"), false);
        } else {
            ((CommandSourceStack)commandContext.getSource()).sendFailure((Component)Component.literal((String)"Command must be run by a player"));
        }
        return 1;
    });
    private static final LiteralArgumentBuilder<CommandSourceStack> DOCTOR_COMMAND = (LiteralArgumentBuilder)Commands.literal((String)"doctor").executes(commandContext -> {
        ModInfo modInfo = Platform.getModInfo("amber");
        if (modInfo == null) {
            ((CommandSourceStack)commandContext.getSource()).sendFailure((Component)Component.literal((String)"Mod info not found!"));
            return 1;
        }
        ((CommandSourceStack)commandContext.getSource()).sendSuccess(() -> {
            MutableComponent message = Component.literal((String)(modInfo.name() + " Doctor\n")).append(" - Version: " + modInfo.version() + "\n").append(" - Platform: " + Platform.getPlatformName() + "\n").append(" - Minecraft: 1.21.7\n").append(" - Networking: " + (AmberNetworking.isInitialized() ? "Initialized" : "Not Initialized") + "\n").append(" - Total Pings: " + AmberNetworking.getTotalPings() + "\n").append(" - Avg Latency: " + (String)(AmberNetworking.getAverageLatency() == -1L ? "No data" : AmberNetworking.getAverageLatency() + "ms") + "\n\n").append("Mixins: \n");
            for (String mixin : AmberMod.AMBER_MIXINS) {
                message.append((Component)Component.literal((String)(mixin + "\n")).withStyle(style -> style.withColor(0xFFAA00)));
            }
            message.append("\n").append("Amber Mods: \n");
            for (AmberModInfo amberMod : AmberMod.AMBER_MODS) {
                message.append((Component)Component.literal((String)String.format("%s - %s\n", amberMod.name(), amberMod.version())).withStyle(style -> style.withColor(43775)));
            }
            return message;
        }, true);
        return 1;
    });
    private static final LiteralArgumentBuilder<CommandSourceStack> RESET_STATS_COMMAND = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reset-stats").requires(source -> source.hasPermission(2))).executes(commandContext -> {
        AmberNetworking.resetStats();
        ((CommandSourceStack)commandContext.getSource()).sendSuccess(() -> Component.literal((String)"Reset networking statistics"), false);
        return 1;
    });

    public static void initialize() {
        CommandEvents.EVENT.register((dispatcher, registryAccess, environment) -> {
            Constants.LOG.info("Registering Amber commands for {}", (Object)Services.PLATFORM.getPlatformName());
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)SimpleCommands.createBaseCommand("amber").then(DOCTOR_COMMAND)).then(PING_COMMAND)).then(RESET_STATS_COMMAND));
        });
    }
}

