/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.networking.forge;

import com.iamkaf.amber.Constants;
import com.iamkaf.amber.api.networking.v1.Packet;
import com.iamkaf.amber.api.networking.v1.PacketDecoder;
import com.iamkaf.amber.api.networking.v1.PacketEncoder;
import com.iamkaf.amber.api.networking.v1.PacketHandler;
import com.iamkaf.amber.api.networking.v1.PlatformNetworkChannel;
import com.iamkaf.amber.networking.forge.ForgePacketContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ForgeNetworkChannelImpl
implements PlatformNetworkChannel {
    private final ResourceLocation channelId;
    private final ConcurrentMap<Class<?>, PacketRegistration<? extends Packet<?>>> registrations = new ConcurrentHashMap();

    public ForgeNetworkChannelImpl(ResourceLocation channelId) {
        this.channelId = channelId;
    }

    @Override
    public <T extends Packet<T>> void register(Class<T> packetClass, PacketEncoder<T> encoder, PacketDecoder<T> decoder, PacketHandler<T> handler) {
        PacketRegistration<T> registration = new PacketRegistration<T>(encoder, decoder, handler);
        this.registrations.put(packetClass, registration);
        Constants.LOG.info("Forge: Registered packet {} for channel {}", (Object)packetClass.getSimpleName(), (Object)this.channelId);
    }

    @Override
    public <T extends Packet<T>> void sendToServer(T packet) {
        PacketRegistration registration = (PacketRegistration)this.registrations.get(packet.getClass());
        if (registration == null) {
            throw new IllegalArgumentException("Packet not registered: " + packet.getClass().getName());
        }
        Constants.LOG.info("Forge: Sending {} to server", (Object)packet.getClass().getSimpleName());
        this.simulatePacketDelivery(packet, registration, false);
    }

    @Override
    public <T extends Packet<T>> void sendToPlayer(T packet, ServerPlayer player) {
        PacketRegistration registration = (PacketRegistration)this.registrations.get(packet.getClass());
        if (registration == null) {
            throw new IllegalArgumentException("Packet not registered: " + packet.getClass().getName());
        }
        Constants.LOG.info("Forge: Sending {} to player {}", (Object)packet.getClass().getSimpleName(), (Object)player.getName().getString());
        this.simulatePacketDelivery(packet, registration, true);
    }

    @Override
    public <T extends Packet<T>> void sendToAllPlayers(T packet) {
        PacketRegistration registration = (PacketRegistration)this.registrations.get(packet.getClass());
        if (registration == null) {
            throw new IllegalArgumentException("Packet not registered: " + packet.getClass().getName());
        }
        Constants.LOG.info("Forge: Sending {} to all players", (Object)packet.getClass().getSimpleName());
        this.simulatePacketDelivery(packet, registration, true);
    }

    @Override
    public <T extends Packet<T>> void sendToAllPlayersExcept(T packet, ServerPlayer except) {
        PacketRegistration registration = (PacketRegistration)this.registrations.get(packet.getClass());
        if (registration == null) {
            throw new IllegalArgumentException("Packet not registered: " + packet.getClass().getName());
        }
        Constants.LOG.info("Forge: Sending {} to all players except {}", (Object)packet.getClass().getSimpleName(), (Object)except.getName().getString());
        this.simulatePacketDelivery(packet, registration, true);
    }

    private <T extends Packet<T>> void simulatePacketDelivery(T packet, PacketRegistration<T> registration, boolean isClientSide) {
        ForgePacketContext context = new ForgePacketContext(isClientSide, null);
        CompletableFuture.delayedExecutor((long)(Math.random() * 20.0) + 5L, TimeUnit.MILLISECONDS).execute(() -> {
            try {
                registration.handler.handle(packet, context);
            }
            catch (Exception e) {
                Constants.LOG.error("Error handling packet: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        });
    }

    private static class PacketRegistration<T extends Packet<T>> {
        final PacketEncoder<T> encoder;
        final PacketDecoder<T> decoder;
        final PacketHandler<T> handler;

        PacketRegistration(PacketEncoder<T> encoder, PacketDecoder<T> decoder, PacketHandler<T> handler) {
            this.encoder = encoder;
            this.decoder = decoder;
            this.handler = handler;
        }
    }
}

