/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.networking.v1;

import com.iamkaf.amber.Constants;
import com.iamkaf.amber.api.networking.v1.NetworkChannel;
import com.iamkaf.amber.networking.v1.PingPacket;
import com.iamkaf.amber.networking.v1.PongPacket;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class AmberNetworking {
    public static final NetworkChannel CHANNEL = NetworkChannel.create(ResourceLocation.fromNamespaceAndPath((String)"amber", (String)"internal"));
    private static final AtomicLong totalPings = new AtomicLong(0L);
    private static final AtomicLong totalLatency = new AtomicLong(0L);
    private static boolean initialized = false;

    public static void initialize() {
        if (initialized) {
            Constants.LOG.debug("Amber networking v2 already initialized");
            return;
        }
        try {
            CHANNEL.register(PingPacket.class, PingPacket.ENCODER, PingPacket.DECODER, PingPacket.HANDLER);
            CHANNEL.register(PongPacket.class, PongPacket.ENCODER, PongPacket.DECODER, PongPacket.HANDLER);
            initialized = true;
            Constants.LOG.info("Amber internal networking initialized");
        }
        catch (Exception e) {
            Constants.LOG.error("Failed to initialize Amber internal networking", (Throwable)e);
        }
    }

    public static void pingPlayer(ServerPlayer player, String reason) {
        if (!initialized) {
            Constants.LOG.warn("Amber networking not initialized, cannot ping player");
            return;
        }
        try {
            long timestamp = System.currentTimeMillis();
            String message = "Amber ping: " + reason;
            PingPacket pingPacket = new PingPacket(timestamp, message);
            CHANNEL.sendToPlayer(pingPacket, player);
            Constants.LOG.debug("Sent ping to player {}: {} (timestamp: {})", new Object[]{player.getName().getString(), reason, timestamp});
        }
        catch (Exception e) {
            Constants.LOG.error("Failed to send ping to player {}", (Object)player.getName().getString(), (Object)e);
        }
    }

    public static void sendToServer(PongPacket pongPacket) {
        if (!initialized) {
            Constants.LOG.warn("Amber networking not initialized, cannot send pong");
            return;
        }
        try {
            CHANNEL.sendToServer(pongPacket);
        }
        catch (Exception e) {
            Constants.LOG.error("Failed to send pong to server", (Throwable)e);
        }
    }

    public static void sendWelcomePing(ServerPlayer player) {
        AmberNetworking.pingPlayer(player, "welcome");
    }

    public static void testConnectivity(ServerPlayer player) {
        AmberNetworking.pingPlayer(player, "connectivity_test");
    }

    public static void recordLatency(long totalLatency, long networkLatency) {
        totalPings.incrementAndGet();
        AmberNetworking.totalLatency.addAndGet(networkLatency);
        Constants.LOG.debug("Recorded latency: total={}ms, network={}ms", (Object)totalLatency, (Object)networkLatency);
    }

    public static long getAverageLatency() {
        long pings = totalPings.get();
        if (pings == 0L) {
            return -1L;
        }
        return totalLatency.get() / pings;
    }

    public static long getTotalPings() {
        return totalPings.get();
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static void resetStats() {
        totalPings.set(0L);
        totalLatency.set(0L);
        Constants.LOG.debug("Amber networking statistics reset");
    }
}

