/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.platform;

import com.iamkaf.amber.api.registry.v1.Registrar;
import com.iamkaf.amber.api.registry.v1.RegistrySupplier;
import com.iamkaf.amber.platform.services.IRegistrarManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ForgeRegistrarManager
implements IRegistrarManager {
    private final Map<String, Map<ResourceKey<? extends Registry<?>>, DeferredRegister<?>>> registers = new HashMap();

    private <T> DeferredRegister<T> getRegister(String modId, ResourceKey<Registry<T>> key) {
        Map map = this.registers.computeIfAbsent(modId, m -> new HashMap());
        return map.computeIfAbsent(key, k -> {
            DeferredRegister reg = DeferredRegister.create((ResourceKey)key, (String)modId);
            reg.register(FMLJavaModLoadingContext.get().getModBusGroup());
            return reg;
        });
    }

    @Override
    public <T> Registrar<T> create(String modId, ResourceKey<Registry<T>> key) {
        return new ForgeRegistrar<T>(key, this.getRegister(modId, key));
    }

    private static class ForgeRegistrar<T>
    implements Registrar<T> {
        private final ResourceKey<Registry<T>> key;
        private final DeferredRegister<T> register;

        ForgeRegistrar(ResourceKey<Registry<T>> key, DeferredRegister<T> register) {
            this.key = key;
            this.register = register;
        }

        @Override
        public <R extends T> RegistrySupplier<R> register(ResourceLocation id, Supplier<? extends R> supplier) {
            RegistryObject obj = this.register.register(id.getPath(), supplier);
            return new ForgeRegistrySupplier(this.key.location(), id, obj);
        }

        @Override
        public ResourceKey<? extends Registry<T>> key() {
            return this.key;
        }

        @Override
        public Optional<Holder.Reference<T>> get(ResourceLocation id) {
            return this.registry().get(id);
        }

        private Registry<T> registry() {
            return (Registry)BuiltInRegistries.REGISTRY.getValue(this.key.location());
        }
    }

    private static class ForgeRegistrySupplier<R>
    implements RegistrySupplier<R> {
        private final ResourceLocation registryId;
        private final ResourceLocation id;
        private final RegistryObject<R> obj;

        ForgeRegistrySupplier(ResourceLocation registryId, ResourceLocation id, RegistryObject<R> obj) {
            this.registryId = registryId;
            this.id = id;
            this.obj = obj;
        }

        @Override
        public boolean isPresent() {
            return this.obj.isPresent();
        }

        @Override
        public R get() {
            return (R)this.obj.get();
        }

        @Override
        public ResourceLocation getRegistryId() {
            return this.registryId;
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }
    }
}

