/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.creativetabs;

import com.iamkaf.amber.api.creativetabs.TabBuilder;
import com.iamkaf.amber.api.registry.v1.RegistrarManager;
import com.iamkaf.amber.api.registry.v1.RegistrySupplier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;

public final class CreativeModeTabRegistry {
    private static final Map<ResourceLocation, TabBuilder> TAB_BUILDERS = new HashMap<ResourceLocation, TabBuilder>();

    private CreativeModeTabRegistry() {
    }

    public static TabBuilder builder(String id) {
        return CreativeModeTabRegistry.builder(ResourceLocation.fromNamespaceAndPath((String)"amber", (String)id));
    }

    public static TabBuilder builder(ResourceLocation id) {
        return new TabBuilder(id);
    }

    public static RegistrySupplier<CreativeModeTab> register(TabBuilder builder) {
        TAB_BUILDERS.put(builder.getId(), builder);
        return RegistrarManager.get("amber").get(Registries.CREATIVE_MODE_TAB).register(builder.getId(), builder::build);
    }

    public static RegistrySupplier<CreativeModeTab> register(String id) {
        return CreativeModeTabRegistry.register(CreativeModeTabRegistry.builder(id));
    }

    public static RegistrySupplier<CreativeModeTab> register(ResourceLocation id) {
        return CreativeModeTabRegistry.register(CreativeModeTabRegistry.builder(id));
    }

    public static Map<ResourceLocation, TabBuilder> getTabBuilders() {
        return Collections.unmodifiableMap(TAB_BUILDERS);
    }

    public static TabBuilder getTabBuilder(ResourceLocation id) {
        return TAB_BUILDERS.get(id);
    }

    public static boolean isTabRegistered(ResourceLocation id) {
        return TAB_BUILDERS.containsKey(id);
    }
}

