/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.event.v1.events.common;

import com.iamkaf.amber.api.event.v1.Event;
import com.iamkaf.amber.api.event.v1.EventFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BlockEvents {
    public static final Event<BlockBreakBefore> BLOCK_BREAK_BEFORE = EventFactory.createArrayBacked(BlockBreakBefore.class, callbacks -> (level, player, pos, state, blockEntity) -> {
        for (BlockBreakBefore callback : callbacks) {
            InteractionResult result = callback.beforeBlockBreak(level, player, pos, state, blockEntity);
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    });
    public static final Event<BlockBreakAfter> BLOCK_BREAK_AFTER = EventFactory.createArrayBacked(BlockBreakAfter.class, callbacks -> (level, player, pos, state, blockEntity) -> {
        for (BlockBreakAfter callback : callbacks) {
            callback.afterBlockBreak(level, player, pos, state, blockEntity);
        }
    });
    public static final Event<BlockPlace> BLOCK_PLACE = EventFactory.createArrayBacked(BlockPlace.class, callbacks -> (level, player, pos, state, context) -> {
        for (BlockPlace callback : callbacks) {
            InteractionResult result = callback.onBlockPlace(level, player, pos, state, context);
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    });
    public static final Event<BlockInteract> BLOCK_INTERACT = EventFactory.createArrayBacked(BlockInteract.class, callbacks -> (player, level, hand, hitResult) -> {
        for (BlockInteract callback : callbacks) {
            InteractionResult result = callback.onBlockInteract(player, level, hand, hitResult);
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    });
    public static final Event<BlockClick> BLOCK_CLICK = EventFactory.createArrayBacked(BlockClick.class, callbacks -> (player, level, hand, pos, direction) -> {
        for (BlockClick callback : callbacks) {
            InteractionResult result = callback.onBlockClick(player, level, hand, pos, direction);
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    });

    @FunctionalInterface
    public static interface BlockClick {
        public InteractionResult onBlockClick(Player var1, Level var2, InteractionHand var3, BlockPos var4, Direction var5);
    }

    @FunctionalInterface
    public static interface BlockInteract {
        public InteractionResult onBlockInteract(Player var1, Level var2, InteractionHand var3, BlockHitResult var4);
    }

    @FunctionalInterface
    public static interface BlockPlace {
        public InteractionResult onBlockPlace(Level var1, Player var2, BlockPos var3, BlockState var4, ItemStack var5);
    }

    @FunctionalInterface
    public static interface BlockBreakAfter {
        public void afterBlockBreak(Level var1, Player var2, BlockPos var3, BlockState var4, BlockEntity var5);
    }

    @FunctionalInterface
    public static interface BlockBreakBefore {
        public InteractionResult beforeBlockBreak(Level var1, Player var2, BlockPos var3, BlockState var4, BlockEntity var5);
    }
}

