/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.event.v1.events.common;

import com.iamkaf.amber.api.event.v1.Event;
import com.iamkaf.amber.api.event.v1.EventFactory;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class EntityEvent {
    public static final Event<EntitySpawn> ENTITY_SPAWN = EventFactory.createArrayBacked(EntitySpawn.class, callbacks -> (entity, level) -> {
        for (EntitySpawn callback : callbacks) {
            callback.onEntitySpawn(entity, level);
        }
    });
    public static final Event<EntityDeath> ENTITY_DEATH = EventFactory.createArrayBacked(EntityDeath.class, callbacks -> (entity, source) -> {
        for (EntityDeath callback : callbacks) {
            callback.onEntityDeath(entity, source);
        }
    });
    public static final Event<EntityDamage> ENTITY_DAMAGE = EventFactory.createArrayBacked(EntityDamage.class, callbacks -> (entity, source, amount) -> {
        for (EntityDamage callback : callbacks) {
            InteractionResult result = callback.onEntityDamage(entity, source, amount);
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    });
    public static final Event<AfterDamage> AFTER_DAMAGE = EventFactory.createArrayBacked(AfterDamage.class, callbacks -> (entity, source, baseDamageTaken, damageTaken, blocked) -> {
        for (AfterDamage callback : callbacks) {
            callback.afterDamage(entity, source, baseDamageTaken, damageTaken, blocked);
        }
    });

    @FunctionalInterface
    public static interface AfterDamage {
        public void afterDamage(LivingEntity var1, DamageSource var2, float var3, float var4, boolean var5);
    }

    @FunctionalInterface
    public static interface EntityDamage {
        public InteractionResult onEntityDamage(LivingEntity var1, DamageSource var2, float var3);
    }

    @FunctionalInterface
    public static interface EntityDeath {
        public void onEntityDeath(LivingEntity var1, DamageSource var2);
    }

    @FunctionalInterface
    public static interface EntitySpawn {
        public void onEntitySpawn(Entity var1, Level var2);
    }
}

