/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.event.v1.events.common;

import com.iamkaf.amber.api.event.v1.Event;
import com.iamkaf.amber.api.event.v1.EventFactory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.LevelAccessor;

public final class WorldEvents {
    public static final Event<WorldLoad> WORLD_LOAD = EventFactory.createArrayBacked(WorldLoad.class, callbacks -> (server, level) -> {
        for (WorldLoad callback : callbacks) {
            callback.onWorldLoad(server, level);
        }
    });
    public static final Event<WorldUnload> WORLD_UNLOAD = EventFactory.createArrayBacked(WorldUnload.class, callbacks -> (server, level) -> {
        for (WorldUnload callback : callbacks) {
            callback.onWorldUnload(server, level);
        }
    });
    public static final Event<WorldSave> WORLD_SAVE = EventFactory.createArrayBacked(WorldSave.class, callbacks -> (server, level) -> {
        for (WorldSave callback : callbacks) {
            callback.onWorldSave(server, level);
        }
    });

    private WorldEvents() {
    }

    @FunctionalInterface
    public static interface WorldSave {
        public void onWorldSave(MinecraftServer var1, LevelAccessor var2);
    }

    @FunctionalInterface
    public static interface WorldUnload {
        public void onWorldUnload(MinecraftServer var1, LevelAccessor var2);
    }

    @FunctionalInterface
    public static interface WorldLoad {
        public void onWorldLoad(MinecraftServer var1, LevelAccessor var2);
    }
}

