/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.networking.forge;

import com.iamkaf.amber.Constants;
import com.iamkaf.amber.api.networking.v1.Packet;
import com.iamkaf.amber.api.networking.v1.PacketDecoder;
import com.iamkaf.amber.api.networking.v1.PacketEncoder;
import com.iamkaf.amber.api.networking.v1.PacketHandler;
import com.iamkaf.amber.api.networking.v1.PlatformNetworkChannel;
import com.iamkaf.amber.networking.forge.ForgePacketContext;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;

public class ForgeNetworkChannelImpl
implements PlatformNetworkChannel {
    private static final int PROTOCOL_VERSION = 1;
    private final ResourceLocation channelId;
    private final SimpleChannel channel;
    private final ConcurrentMap<Class<?>, PacketRegistration<? extends Packet<?>>> registrations = new ConcurrentHashMap();

    public ForgeNetworkChannelImpl(ResourceLocation channelId) {
        this.channelId = channelId;
        this.channel = ChannelBuilder.named((ResourceLocation)channelId).networkProtocolVersion(1).clientAcceptedVersions(Channel.VersionTest.exact((int)1)).serverAcceptedVersions(Channel.VersionTest.exact((int)1)).simpleChannel();
    }

    @Override
    public <T extends Packet<T>> void register(Class<T> packetClass, PacketEncoder<T> encoder, PacketDecoder<T> decoder, PacketHandler<T> handler) {
        PacketRegistration<T> registration = new PacketRegistration<T>(encoder, decoder, handler);
        this.registrations.put(packetClass, registration);
        StreamCodec codec = StreamCodec.of((buffer, packet) -> encoder.encode((Object)packet, (FriendlyByteBuf)buffer), buffer -> decoder.decode((FriendlyByteBuf)buffer));
        this.channel.messageBuilder(packetClass).decoder(buffer -> decoder.decode((FriendlyByteBuf)buffer)).encoder((packet, buffer) -> encoder.encode((Object)packet, (FriendlyByteBuf)buffer)).consumerMainThread((packet, context) -> {
            ServerPlayer sender = context.getSender();
            ForgePacketContext packetContext = new ForgePacketContext(sender == null, (Player)sender);
            try {
                handler.handle(packet, packetContext);
            }
            catch (Exception e) {
                Constants.LOG.error("Error handling packet: {}", (Object)e.getMessage(), (Object)e);
            }
        }).add();
        Constants.LOG.info("Forge: Registered packet {} for channel {}", (Object)packetClass.getSimpleName(), (Object)this.channelId);
    }

    @Override
    public <T extends Packet<T>> void sendToServer(T packet) {
        if (!this.isClientSide()) {
            throw new IllegalStateException("sendToServer can only be called from client side");
        }
        PacketRegistration registration = (PacketRegistration)this.registrations.get(packet.getClass());
        if (registration == null) {
            throw new IllegalArgumentException("Packet not registered: " + packet.getClass().getName());
        }
        Constants.LOG.debug("Forge: Sending {} to server", (Object)packet.getClass().getSimpleName());
        this.channel.send(packet, PacketDistributor.SERVER.noArg());
    }

    @Override
    public <T extends Packet<T>> void sendToPlayer(T packet, ServerPlayer player) {
        PacketRegistration registration = (PacketRegistration)this.registrations.get(packet.getClass());
        if (registration == null) {
            throw new IllegalArgumentException("Packet not registered: " + packet.getClass().getName());
        }
        Constants.LOG.debug("Forge: Sending {} to player {}", (Object)packet.getClass().getSimpleName(), (Object)player.getName().getString());
        this.channel.send(packet, PacketDistributor.PLAYER.with((Object)player));
    }

    @Override
    public <T extends Packet<T>> void sendToAllPlayers(T packet) {
        PacketRegistration registration = (PacketRegistration)this.registrations.get(packet.getClass());
        if (registration == null) {
            throw new IllegalArgumentException("Packet not registered: " + packet.getClass().getName());
        }
        Constants.LOG.debug("Forge: Sending {} to all players", (Object)packet.getClass().getSimpleName());
        this.channel.send(packet, PacketDistributor.ALL.noArg());
    }

    @Override
    public <T extends Packet<T>> void sendToAllPlayersExcept(T packet, ServerPlayer except) {
        PacketRegistration registration = (PacketRegistration)this.registrations.get(packet.getClass());
        if (registration == null) {
            throw new IllegalArgumentException("Packet not registered: " + packet.getClass().getName());
        }
        Constants.LOG.debug("Forge: Sending {} to all players except {}", (Object)packet.getClass().getSimpleName(), (Object)except.getName().getString());
        ServerLevel serverLevel = except.level();
        if (serverLevel instanceof ServerLevel) {
            ServerLevel serverLevel2 = serverLevel;
            for (ServerPlayer player : serverLevel2.getServer().getPlayerList().getPlayers()) {
                if (player.equals((Object)except)) continue;
                this.channel.send(packet, PacketDistributor.PLAYER.with((Object)player));
            }
        }
    }

    private boolean isClientSide() {
        try {
            return FMLLoader.getDist().isClient();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class PacketRegistration<T extends Packet<T>> {
        final PacketEncoder<T> encoder;
        final PacketDecoder<T> decoder;
        final PacketHandler<T> handler;

        PacketRegistration(PacketEncoder<T> encoder, PacketDecoder<T> decoder, PacketHandler<T> handler) {
            this.encoder = encoder;
            this.decoder = decoder;
            this.handler = handler;
        }
    }
}

