/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.platform;

import com.iamkaf.amber.api.event.v1.events.common.AnimalEvents;
import com.iamkaf.amber.api.event.v1.events.common.BlockEvents;
import com.iamkaf.amber.api.event.v1.events.common.CommandEvents;
import com.iamkaf.amber.api.event.v1.events.common.CreativeModeTabEvents;
import com.iamkaf.amber.api.event.v1.events.common.EntityEvent;
import com.iamkaf.amber.api.event.v1.events.common.ItemEvents;
import com.iamkaf.amber.api.event.v1.events.common.LootEvents;
import com.iamkaf.amber.api.event.v1.events.common.PlayerEvents;
import com.iamkaf.amber.api.event.v1.events.common.ServerTickEvents;
import com.iamkaf.amber.api.event.v1.events.common.WeatherEvents;
import com.iamkaf.amber.api.event.v1.events.common.WorldEvents;
import com.iamkaf.amber.api.event.v1.events.common.client.ClientCommandEvents;
import com.iamkaf.amber.api.event.v1.events.common.client.ClientTickEvents;
import com.iamkaf.amber.api.keymapping.KeybindHelper;
import com.iamkaf.amber.platform.services.IAmberEventSetup;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.KeyMapping;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.fml.LogicalSide;

public class ForgeAmberEventSetup
implements IAmberEventSetup {
    @Override
    public void registerCommon() {
        LootTableLoadEvent.BUS.addListener(EventHandlerCommon::onLootTableEvent);
        PlayerInteractEvent.EntityInteract.BUS.addListener(EventHandlerCommon::onPlayerEntityInteract);
        RegisterCommandsEvent.BUS.addListener(EventHandlerCommon::onCommandRegistration);
        EntityJoinLevelEvent.BUS.addListener(EventHandlerCommon::onEntityJoinLevel);
        LivingDeathEvent.BUS.addListener(EventHandlerCommon::onLivingDeath);
        LivingAttackEvent.BUS.addListener(EventHandlerCommon::onLivingAttack);
        LevelEvent.Load.BUS.addListener(EventHandlerCommon::onWorldLoad);
        LevelEvent.Unload.BUS.addListener(EventHandlerCommon::onWorldUnload);
        LevelEvent.Save.BUS.addListener(EventHandlerCommon::onWorldSave);
        EntityStruckByLightningEvent.BUS.addListener(EventHandlerCommon::onLightningStrike);
        BlockEvent.BreakEvent.BUS.addListener(EventHandlerCommon::onBlockBreak);
        BlockEvent.EntityPlaceEvent.BUS.addListener(EventHandlerCommon::onBlockPlace);
        PlayerInteractEvent.RightClickBlock.BUS.addListener(EventHandlerCommon::onBlockInteract);
        PlayerInteractEvent.LeftClickBlock.BUS.addListener(EventHandlerCommon::onBlockClick);
        AnimalTameEvent.BUS.addListener(EventHandlerCommon::onAnimalTame);
        BabyEntitySpawnEvent.BUS.addListener(EventHandlerCommon::onAnimalBreed);
        BuildCreativeModeTabContentsEvent.BUS.addListener(EventHandlerCommon::buildContents);
    }

    @Override
    public void registerClient() {
        RegisterClientCommandsEvent.BUS.addListener(EventHandlerClient::onCommandRegistration);
        RegisterKeyMappingsEvent.BUS.addListener(EventHandlerClient::onKeybindRegistration);
        TickEvent.ClientTickEvent.Pre.BUS.addListener(EventHandlerClient::onClientTickEventPre);
        TickEvent.ClientTickEvent.Post.BUS.addListener(EventHandlerClient::onClientTickEventPost);
    }

    @Override
    public void registerServer() {
        TickEvent.ServerTickEvent.Pre.BUS.addListener(EventHandlerServer::onServerTickEventPre);
        TickEvent.ServerTickEvent.Post.BUS.addListener(EventHandlerServer::onServerTickEventPost);
        PlayerEvent.PlayerLoggedInEvent.BUS.addListener(EventHandlerCommon::onPlayerJoin);
        PlayerEvent.PlayerLoggedOutEvent.BUS.addListener(EventHandlerCommon::onPlayerLeave);
        PlayerEvent.PlayerRespawnEvent.BUS.addListener(EventHandlerCommon::onPlayerRespawn);
        ItemTossEvent.BUS.addListener(EventHandlerCommon::onItemDrop);
        EntityItemPickupEvent.BUS.addListener(EventHandlerCommon::onItemPickup);
    }

    public static class EventHandlerServer {
        public static void onServerTickEventPre(TickEvent.ServerTickEvent.Pre pre) {
            ServerTickEvents.START_SERVER_TICK.invoker().onStartTick();
        }

        public static void onServerTickEventPost(TickEvent.ServerTickEvent.Post post) {
            ServerTickEvents.END_SERVER_TICK.invoker().onEndTick();
        }
    }

    public static class EventHandlerClient {
        public static void onCommandRegistration(RegisterClientCommandsEvent event) {
            ClientCommandEvents.EVENT.invoker().register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
        }

        public static void onKeybindRegistration(RegisterKeyMappingsEvent event) {
            for (KeyMapping keyMapping : KeybindHelper.getKeybindings()) {
                event.register(keyMapping);
            }
            KeybindHelper.forgeEventAlreadyFired = true;
        }

        public static void onClientTickEventPre(TickEvent.ClientTickEvent.Pre pre) {
            ClientTickEvents.START_CLIENT_TICK.invoker().onStartTick();
        }

        public static void onClientTickEventPost(TickEvent.ClientTickEvent.Post post) {
            ClientTickEvents.END_CLIENT_TICK.invoker().onEndTick();
        }
    }

    public static class EventHandlerCommon {
        public static void onLootTableEvent(LootTableLoadEvent event) {
            LootEvents.MODIFY.invoker().modify(event.getName(), lootPool -> event.getTable().addPool(lootPool.build()));
        }

        public static boolean onPlayerEntityInteract(PlayerInteractEvent.EntityInteract event) {
            InteractionResult result = PlayerEvents.ENTITY_INTERACT.invoker().interact(event.getEntity(), event.getLevel(), event.getHand(), event.getTarget());
            LogicalSide side = event.getSide();
            if (result.equals((Object)InteractionResult.PASS)) {
                return false;
            }
            if (side.isClient()) {
                if (result == InteractionResult.SUCCESS) {
                    event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                    return true;
                }
                if (result == InteractionResult.CONSUME) {
                    event.setCancellationResult((InteractionResult)InteractionResult.CONSUME);
                    return true;
                }
                return true;
            }
            return false;
        }

        public static void onCommandRegistration(RegisterCommandsEvent event) {
            CommandEvents.EVENT.invoker().register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
        }

        public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
            EntityEvent.ENTITY_SPAWN.invoker().onEntitySpawn(event.getEntity(), event.getLevel());
        }

        public static void onLivingDeath(LivingDeathEvent event) {
            EntityEvent.ENTITY_DEATH.invoker().onEntityDeath(event.getEntity(), event.getSource());
        }

        public static boolean onLivingAttack(LivingAttackEvent event) {
            InteractionResult result = EntityEvent.ENTITY_DAMAGE.invoker().onEntityDamage(event.getEntity(), event.getSource(), event.getAmount());
            return result != InteractionResult.PASS;
        }

        public static boolean onBlockBreak(BlockEvent.BreakEvent event) {
            InteractionResult result = BlockEvents.BLOCK_BREAK_BEFORE.invoker().beforeBlockBreak(event.getPlayer().level(), event.getPlayer(), event.getPos(), event.getState(), event.getLevel().getBlockEntity(event.getPos()));
            if (result != InteractionResult.PASS) {
                return true;
            }
            BlockEvents.BLOCK_BREAK_AFTER.invoker().afterBlockBreak(event.getPlayer().level(), event.getPlayer(), event.getPos(), event.getState(), event.getLevel().getBlockEntity(event.getPos()));
            return false;
        }

        public static boolean onBlockPlace(BlockEvent.EntityPlaceEvent event) {
            Entity entity = event.getEntity();
            if (!(entity instanceof Player)) {
                return false;
            }
            Player player = (Player)entity;
            InteractionResult result = BlockEvents.BLOCK_PLACE.invoker().onBlockPlace(player.level(), player, event.getPos(), event.getPlacedBlock(), player.getMainHandItem());
            return result != InteractionResult.PASS;
        }

        public static boolean onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
            InteractionResult result = BlockEvents.BLOCK_INTERACT.invoker().onBlockInteract(event.getEntity(), event.getEntity().level(), event.getHand(), event.getHitVec());
            return result != InteractionResult.PASS;
        }

        public static boolean onBlockClick(PlayerInteractEvent.LeftClickBlock event) {
            InteractionResult result = BlockEvents.BLOCK_CLICK.invoker().onBlockClick(event.getEntity(), event.getEntity().level(), event.getHand(), event.getPos(), event.getFace());
            return result != InteractionResult.PASS;
        }

        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PlayerEvents.PLAYER_JOIN.invoker().onPlayerJoin(serverPlayer);
            }
        }

        public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PlayerEvents.PLAYER_LEAVE.invoker().onPlayerLeave(serverPlayer);
            }
        }

        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer newPlayer = (ServerPlayer)player;
                PlayerEvents.PLAYER_RESPAWN.invoker().onPlayerRespawn(newPlayer, newPlayer, !event.isEndConquered());
            }
        }

        public static void onItemDrop(ItemTossEvent event) {
            ItemEvents.ITEM_DROP.invoker().onItemDrop(event.getPlayer(), event.getEntity());
        }

        public static void onItemPickup(EntityItemPickupEvent event) {
            if (event.getItem().hasPickUpDelay()) {
                return;
            }
            ItemEvents.ITEM_PICKUP.invoker().onItemPickup(event.getEntity(), event.getItem(), event.getItem().getItem());
        }

        public static boolean onAnimalTame(AnimalTameEvent event) {
            if (event.getTamer() == null) {
                return false;
            }
            InteractionResult result = AnimalEvents.ANIMAL_TAME.invoker().onAnimalTame((LivingEntity)event.getAnimal(), event.getTamer());
            return result != InteractionResult.PASS;
        }

        public static void onAnimalBreed(BabyEntitySpawnEvent event) {
            Mob mob = event.getParentA();
            if (mob instanceof Animal) {
                Animal parentA = (Animal)mob;
                mob = event.getParentB();
                if (mob instanceof Animal) {
                    Animal parentB = (Animal)mob;
                    AnimalEvents.ANIMAL_BREED.invoker().onAnimalBreed(parentA, parentB, event.getChild());
                }
            }
        }

        public static void onWorldLoad(LevelEvent.Load event) {
            WorldEvents.WORLD_LOAD.invoker().onWorldLoad(event.getLevel().getServer(), event.getLevel());
        }

        public static void onWorldUnload(LevelEvent.Unload event) {
            WorldEvents.WORLD_UNLOAD.invoker().onWorldUnload(event.getLevel().getServer(), event.getLevel());
        }

        public static void onWorldSave(LevelEvent.Save event) {
            WorldEvents.WORLD_SAVE.invoker().onWorldSave(event.getLevel().getServer(), event.getLevel());
        }

        public static boolean onLightningStrike(EntityStruckByLightningEvent event) {
            InteractionResult result = WeatherEvents.LIGHTNING_STRIKE.invoker().onLightningStrike(event.getEntity(), event.getLightning());
            return result != InteractionResult.PASS;
        }

        public static void buildContents(BuildCreativeModeTabContentsEvent event) {
            CreativeModeTabEvents.MODIFY_ENTRIES.invoker().modifyEntries((ResourceKey<CreativeModeTab>)event.getTabKey(), (arg_0, arg_1) -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0, arg_1));
        }
    }
}

