/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.common.client;

import com.iamkaf.amber.Constants;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CommonClientUtils {
    public static final int WHITE = -1;
    public static final int BLACK = 255;
    public static final int TRANSPARENT = 0;
    public static final int PACKED_LIGHT = 0xF000F0;

    public static boolean shouldRender() {
        Minecraft mc = Minecraft.getInstance();
        try {
            return !mc.getDebugOverlay().showDebugScreen() && !mc.options.hideGui && mc.level != null && mc.player != null;
        }
        catch (Exception e) {
            Constants.LOG.error("An error occurred while checking if the HUD should be rendered: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static void text(GuiGraphics context, Font font, Component message, int x, int y, int color) {
        context.drawString(font, message, x, y, color);
    }

    public static void renderTooltip(GuiGraphics guiGraphics, ItemStack stack, int x, int y) {
        Minecraft mc = Minecraft.getInstance();
        List<ClientTooltipComponent> tooltipComponents = Screen.getTooltipFromItem((Minecraft)mc, (ItemStack)stack).stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).toList();
        guiGraphics.renderTooltip(mc.font, tooltipComponents, x, y, DefaultTooltipPositioner.INSTANCE, (ResourceLocation)stack.get(DataComponents.TOOLTIP_STYLE));
    }

    public static final class TextWriter {
        private final GuiGraphics context;
        private final Font font;
        private int cursorX = 0;
        private int cursorY = 0;

        public TextWriter(GuiGraphics context, Font font) {
            this.context = context;
            this.font = font;
        }

        public TextWriter(GuiGraphics context, Font font, int x, int y) {
            this(context, font);
            this.cursorX = x;
            this.cursorY = y;
        }

        public void write(Component message, int x, int y, int color) {
            this.cursorX = x;
            this.cursorY = y;
            CommonClientUtils.text(this.context, this.font, message, this.cursorX, this.cursorY, color);
        }

        public void write(Component message, int x, int y) {
            this.cursorX = x;
            this.cursorY = y;
            this.write(message, this.cursorX, this.cursorY, -1);
        }

        public void write(Component message) {
            this.write(message, this.cursorX, this.cursorY, -1);
        }

        public void writeLine(Component message, int color) {
            CommonClientUtils.text(this.context, this.font, message, this.cursorX, this.cursorY, color);
            Objects.requireNonNull(this.font);
            this.cursorY += 9;
        }

        public void writeLine(Component message) {
            this.writeLine(message, -1);
        }
    }
}

