/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.config.v1;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonReader;
import com.iamkaf.amber.Constants;
import com.iamkaf.amber.platform.Services;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.Nullable;

public class JsonConfigManager<T> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final T initialConfig;
    private final Path configPath;
    private final String modId;
    private String headerComment = "";
    private T config;

    public JsonConfigManager(String modId, T initialConfig, @Nullable Path configPath, @Nullable String headerComment) {
        this.modId = modId;
        this.headerComment = headerComment;
        this.config = initialConfig;
        this.initialConfig = initialConfig;
        this.configPath = configPath == null ? Services.PLATFORM.getConfigDirectory().resolve(modId + ".json5") : configPath;
    }

    public T getConfig() {
        if (this.config == null) {
            this.loadConfig();
        }
        return this.config;
    }

    public void loadConfig() {
        block8: {
            try {
                if (Files.exists(this.configPath, new LinkOption[0])) {
                    try (JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(this.configPath));){
                        reader.setStrictness(Strictness.LEGACY_STRICT);
                        this.config = GSON.fromJson(reader, this.initialConfig.getClass());
                        break block8;
                    }
                }
                this.saveConfig();
                Constants.LOG.info("Created default configuration at {} for mod {}.", (Object)this.configPath.toAbsolutePath(), (Object)this.modId);
            }
            catch (Exception e) {
                Constants.LOG.error("Could not read config at {} for mod {}. Using defaults. Please check the file for errors.", this.configPath == null ? "<unknown>" : this.configPath.toAbsolutePath(), (Object)this.modId);
                Constants.LOG.error("{}", (Object)e.getMessage());
                this.config = this.initialConfig;
            }
        }
    }

    public void saveConfig() {
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);){
                writer.write(this.headerComment);
                GSON.toJson(this.config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to save config to {} for mod {}. Changes may be lost.", (Object)this.configPath.toAbsolutePath(), (Object)this.modId);
            Constants.LOG.error("{}", (Object)e.getMessage());
        }
    }
}

