/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.creativetabs;

import com.iamkaf.amber.api.event.v1.events.common.CreativeModeTabEvents;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;

public final class CreativeTabHelper {
    private CreativeTabHelper() {
    }

    public static void addItem(ResourceKey<CreativeModeTab> tabKey, Supplier<ItemLike> item) {
        CreativeModeTabEvents.MODIFY_ENTRIES.register((key, output) -> {
            if (key.equals(tabKey)) {
                output.accept((ItemLike)item.get());
            }
        });
    }

    public static void addItem(ResourceKey<CreativeModeTab> tabKey, ItemLike item) {
        CreativeTabHelper.addItem(tabKey, () -> item);
    }

    public static void addItems(ResourceKey<CreativeModeTab> tabKey, Supplier<ItemLike> ... items) {
        CreativeModeTabEvents.MODIFY_ENTRIES.register((key, output) -> {
            if (key.equals(tabKey)) {
                for (Supplier item : items) {
                    output.accept((ItemLike)item.get());
                }
            }
        });
    }

    public static void addItems(ResourceKey<CreativeModeTab> tabKey, ItemLike ... items) {
        CreativeModeTabEvents.MODIFY_ENTRIES.register((key, output) -> {
            if (key.equals(tabKey)) {
                for (ItemLike item : items) {
                    output.accept(item);
                }
            }
        });
    }

    public static void addItemsToTab(ResourceLocation tabId, Supplier<ItemLike> ... items) {
        ResourceKey tabKey = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)tabId);
        CreativeModeTabEvents.MODIFY_ENTRIES.register((key, output) -> {
            if (key.equals(tabKey)) {
                for (Supplier item : items) {
                    output.accept((ItemLike)item.get());
                }
            }
        });
    }

    public static void addItemsToTab(ResourceLocation tabId, ItemLike ... items) {
        ResourceKey tabKey = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)tabId);
        CreativeModeTabEvents.MODIFY_ENTRIES.register((key, output) -> {
            if (key.equals(tabKey)) {
                for (ItemLike item : items) {
                    output.accept(item);
                }
            }
        });
    }
}

