/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.creativetabs;

import com.iamkaf.amber.api.event.v1.events.common.CreativeModeTabEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TabBuilder {
    private final ResourceLocation id;
    private Component title = Component.empty();
    private Supplier<ItemStack> icon = () -> ItemStack.EMPTY;
    private final List<Supplier<ItemLike>> items = new ArrayList<Supplier<ItemLike>>();
    private ResourceLocation backgroundTexture = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/creative_inventory/tab_items.png");
    private boolean canScroll = true;
    private boolean showTitle = true;
    private boolean alignedRight = false;
    private CreativeModeTab.Row row = CreativeModeTab.Row.TOP;
    private int column = 0;
    private CreativeModeTab.Type type = CreativeModeTab.Type.CATEGORY;

    TabBuilder(ResourceLocation id) {
        this.id = id;
    }

    public TabBuilder title(Component title) {
        this.title = title;
        return this;
    }

    public TabBuilder icon(Supplier<ItemStack> icon) {
        this.icon = icon;
        return this;
    }

    public TabBuilder icon(ItemLike icon) {
        return this.icon(() -> new ItemStack(icon));
    }

    public TabBuilder addItem(Supplier<ItemLike> item) {
        this.items.add(item);
        return this;
    }

    public TabBuilder addItem(ItemLike item) {
        return this.addItem(() -> item);
    }

    public TabBuilder addItems(ItemLike ... items) {
        for (ItemLike item : items) {
            this.addItem(item);
        }
        return this;
    }

    public TabBuilder backgroundTexture(ResourceLocation backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public TabBuilder canScroll(boolean canScroll) {
        this.canScroll = canScroll;
        return this;
    }

    public TabBuilder showTitle(boolean showTitle) {
        this.showTitle = showTitle;
        return this;
    }

    public TabBuilder alignedRight(boolean alignedRight) {
        this.alignedRight = alignedRight;
        return this;
    }

    public TabBuilder row(CreativeModeTab.Row row) {
        this.row = row;
        return this;
    }

    public TabBuilder column(int column) {
        this.column = column;
        return this;
    }

    public TabBuilder type(CreativeModeTab.Type type) {
        this.type = type;
        return this;
    }

    CreativeModeTab build() {
        CreativeModeTab.Builder builder = CreativeModeTab.builder((CreativeModeTab.Row)this.row, (int)this.column);
        builder.title(this.title);
        builder.icon(this.icon);
        builder.displayItems((params, output) -> {
            for (Supplier<ItemLike> item : this.items) {
                output.accept(item.get());
            }
            ResourceKey tabKey = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)this.id);
            CreativeModeTabEvents.MODIFY_ENTRIES.invoker().modifyEntries((ResourceKey<CreativeModeTab>)tabKey, output);
        });
        if (this.alignedRight) {
            builder.alignedRight();
        }
        if (!this.showTitle) {
            builder.hideTitle();
        }
        if (!this.canScroll) {
            builder.noScrollBar();
        }
        return builder.build();
    }

    public ResourceLocation getId() {
        return this.id;
    }
}

