/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.networking.v1;

import com.iamkaf.amber.api.networking.v1.NetworkChannel;
import com.iamkaf.amber.api.networking.v1.Packet;
import com.iamkaf.amber.api.networking.v1.PacketDecoder;
import com.iamkaf.amber.api.networking.v1.PacketEncoder;
import com.iamkaf.amber.api.networking.v1.PacketHandler;
import com.iamkaf.amber.api.networking.v1.PlatformNetworkChannel;
import com.iamkaf.amber.platform.Services;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

class NetworkChannelImpl
implements NetworkChannel {
    private static final ConcurrentMap<ResourceLocation, NetworkChannelImpl> CHANNELS = new ConcurrentHashMap<ResourceLocation, NetworkChannelImpl>();
    private final ResourceLocation channelId;
    private final PlatformNetworkChannel platformChannel;

    private NetworkChannelImpl(ResourceLocation channelId) {
        this.channelId = channelId;
        this.platformChannel = Services.NETWORKING.createChannel(channelId);
    }

    static NetworkChannel create(ResourceLocation channelId) {
        return CHANNELS.computeIfAbsent(channelId, NetworkChannelImpl::new);
    }

    @Override
    public <T extends Packet<T>> void register(Class<T> packetClass, PacketEncoder<T> encoder, PacketDecoder<T> decoder, PacketHandler<T> handler) {
        this.platformChannel.register(packetClass, encoder, decoder, handler);
    }

    @Override
    public <T extends Packet<T>> void sendToServer(T packet) {
        this.platformChannel.sendToServer(packet);
    }

    @Override
    public <T extends Packet<T>> void sendToPlayer(T packet, ServerPlayer player) {
        this.platformChannel.sendToPlayer(packet, player);
    }

    @Override
    public <T extends Packet<T>> void sendToAllPlayers(T packet) {
        this.platformChannel.sendToAllPlayers(packet);
    }

    @Override
    public <T extends Packet<T>> void sendToAllPlayersExcept(T packet, ServerPlayer except) {
        this.platformChannel.sendToAllPlayersExcept(packet, except);
    }

    @Override
    public ResourceLocation getChannelId() {
        return this.channelId;
    }
}

