/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.networking.neoforge;

import com.iamkaf.amber.api.networking.v1.Packet;
import com.iamkaf.amber.api.networking.v1.PacketDecoder;
import com.iamkaf.amber.api.networking.v1.PacketEncoder;
import com.iamkaf.amber.api.networking.v1.PacketHandler;
import com.iamkaf.amber.api.networking.v1.PlatformNetworkChannel;
import com.iamkaf.amber.networking.neoforge.NeoForgePacketContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NeoForgeNetworkChannelImpl
implements PlatformNetworkChannel {
    private final ResourceLocation channelId;
    private final ConcurrentMap<Class<?>, PacketRegistration<? extends Packet<?>>> registrations = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, PayloadTypePair<?>> packetToPayloadTypes = new ConcurrentHashMap();
    private PayloadRegistrar registrar;
    private boolean initialized = false;
    private static final ConcurrentMap<ResourceLocation, Boolean> registeredPayloads = new ConcurrentHashMap<ResourceLocation, Boolean>();

    public NeoForgeNetworkChannelImpl(ResourceLocation channelId) {
        this.channelId = channelId;
    }

    public void setPayloadRegistrar(PayloadRegistrar registrar) {
        this.registrar = registrar;
        this.initialized = true;
        for (Map.Entry entry : this.registrations.entrySet()) {
            this.registerPendingPacket((Class)entry.getKey(), (PacketRegistration)entry.getValue());
        }
    }

    @Override
    public <T extends Packet<T>> void register(Class<T> packetClass, PacketEncoder<T> encoder, PacketDecoder<T> decoder, PacketHandler<T> handler) {
        PacketRegistration<T> registration = new PacketRegistration<T>(encoder, decoder, handler);
        this.registrations.put(packetClass, registration);
    }

    private <T extends Packet<T>> void registerPendingPacket(Class<?> packetClass, PacketRegistration<?> registration) {
        PacketRegistration<?> typedRegistration = registration;
        Class<?> typedPacketClass = packetClass;
        ResourceLocation c2sPacketId = ResourceLocation.fromNamespaceAndPath((String)this.channelId.getNamespace(), (String)(this.channelId.getPath() + "/" + packetClass.getSimpleName().toLowerCase() + "_c2s"));
        ResourceLocation s2cPacketId = ResourceLocation.fromNamespaceAndPath((String)this.channelId.getNamespace(), (String)(this.channelId.getPath() + "/" + packetClass.getSimpleName().toLowerCase() + "_s2c"));
        if (registeredPayloads.putIfAbsent(c2sPacketId, true) != null || registeredPayloads.putIfAbsent(s2cPacketId, true) != null) {
            return;
        }
        CustomPacketPayload.Type c2sPayloadType = new CustomPacketPayload.Type(c2sPacketId);
        CustomPacketPayload.Type s2cPayloadType = new CustomPacketPayload.Type(s2cPacketId);
        StreamCodec c2sStreamCodec = StreamCodec.of((buffer, wrapper) -> typedRegistration.encoder.encode(wrapper.packet, (FriendlyByteBuf)buffer), buffer -> new NeoForgePacketWrapper(typedRegistration.decoder.decode((FriendlyByteBuf)buffer), c2sPayloadType));
        StreamCodec s2cStreamCodec = StreamCodec.of((buffer, wrapper) -> typedRegistration.encoder.encode(wrapper.packet, (FriendlyByteBuf)buffer), buffer -> new NeoForgePacketWrapper(typedRegistration.decoder.decode((FriendlyByteBuf)buffer), s2cPayloadType));
        this.registrar.playToServer(c2sPayloadType, c2sStreamCodec, (payload, context) -> {
            NeoForgePacketContext packetContext = new NeoForgePacketContext(false, context.player());
            typedRegistration.handler.handle(payload.packet, packetContext);
        });
        this.registrar.playToClient(s2cPayloadType, s2cStreamCodec, (payload, context) -> {
            NeoForgePacketContext packetContext = new NeoForgePacketContext(true, context.player());
            typedRegistration.handler.handle(payload.packet, packetContext);
        });
        this.packetToPayloadTypes.put(packetClass, new PayloadTypePair(c2sPayloadType, s2cPayloadType));
    }

    @Override
    public <T extends Packet<T>> void sendToServer(T packet) {
        if (!this.isClientSide()) {
            throw new IllegalStateException("sendToServer can only be called from client side");
        }
        PacketRegistration registration = (PacketRegistration)this.registrations.get(packet.getClass());
        if (registration == null) {
            throw new IllegalArgumentException("Packet not registered: " + packet.getClass().getName());
        }
        PayloadTypePair payloadTypes = (PayloadTypePair)this.packetToPayloadTypes.get(packet.getClass());
        if (payloadTypes == null) {
            throw new IllegalArgumentException("Payload types not found for packet: " + packet.getClass().getName());
        }
        NeoForgePacketWrapper<T> wrapper = new NeoForgePacketWrapper<T>(packet, payloadTypes.c2sType);
        if (!FMLEnvironment.getDist().isClient()) {
            throw new IllegalStateException("sendToServer can only be called from client side");
        }
        Minecraft.getInstance().getConnection().send(wrapper);
    }

    @Override
    public <T extends Packet<T>> void sendToPlayer(T packet, ServerPlayer player) {
        PacketRegistration registration = (PacketRegistration)this.registrations.get(packet.getClass());
        if (registration == null) {
            throw new IllegalArgumentException("Packet not registered: " + packet.getClass().getName());
        }
        PayloadTypePair payloadTypes = (PayloadTypePair)this.packetToPayloadTypes.get(packet.getClass());
        if (payloadTypes == null) {
            throw new IllegalArgumentException("Payload types not found for packet: " + packet.getClass().getName());
        }
        NeoForgePacketWrapper<T> wrapper = new NeoForgePacketWrapper<T>(packet, payloadTypes.s2cType);
        player.connection.send(wrapper);
    }

    @Override
    public <T extends Packet<T>> void sendToAllPlayers(T packet) {
        PacketRegistration registration = (PacketRegistration)this.registrations.get(packet.getClass());
        if (registration == null) {
            throw new IllegalArgumentException("Packet not registered: " + packet.getClass().getName());
        }
        PayloadTypePair payloadTypes = (PayloadTypePair)this.packetToPayloadTypes.get(packet.getClass());
        if (payloadTypes == null) {
            throw new IllegalArgumentException("Payload types not found for packet: " + packet.getClass().getName());
        }
        NeoForgePacketWrapper<T> wrapper = new NeoForgePacketWrapper<T>(packet, payloadTypes.s2cType);
        throw new UnsupportedOperationException("sendToAllPlayers requires server access - not yet implemented");
    }

    @Override
    public <T extends Packet<T>> void sendToAllPlayersExcept(T packet, ServerPlayer except) {
        PacketRegistration registration = (PacketRegistration)this.registrations.get(packet.getClass());
        if (registration == null) {
            throw new IllegalArgumentException("Packet not registered: " + packet.getClass().getName());
        }
        PayloadTypePair payloadTypes = (PayloadTypePair)this.packetToPayloadTypes.get(packet.getClass());
        if (payloadTypes == null) {
            throw new IllegalArgumentException("Payload types not found for packet: " + packet.getClass().getName());
        }
        NeoForgePacketWrapper<T> wrapper = new NeoForgePacketWrapper<T>(packet, payloadTypes.s2cType);
        ServerLevel serverLevel = except.level();
        if (serverLevel instanceof ServerLevel) {
            ServerLevel serverLevel2 = serverLevel;
            for (ServerPlayer player : serverLevel2.getServer().getPlayerList().getPlayers()) {
                if (player.equals((Object)except)) continue;
                player.connection.send(wrapper);
            }
        }
    }

    private boolean isClientSide() {
        try {
            return FMLEnvironment.getDist().isClient();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class PacketRegistration<T extends Packet<T>> {
        final PacketEncoder<T> encoder;
        final PacketDecoder<T> decoder;
        final PacketHandler<T> handler;

        PacketRegistration(PacketEncoder<T> encoder, PacketDecoder<T> decoder, PacketHandler<T> handler) {
            this.encoder = encoder;
            this.decoder = decoder;
            this.handler = handler;
        }
    }

    private static class PayloadTypePair<T extends Packet<T>> {
        final CustomPacketPayload.Type<NeoForgePacketWrapper<T>> c2sType;
        final CustomPacketPayload.Type<NeoForgePacketWrapper<T>> s2cType;

        PayloadTypePair(CustomPacketPayload.Type<NeoForgePacketWrapper<T>> c2sType, CustomPacketPayload.Type<NeoForgePacketWrapper<T>> s2cType) {
            this.c2sType = c2sType;
            this.s2cType = s2cType;
        }
    }

    public static class NeoForgePacketWrapper<T extends Packet<T>>
    implements CustomPacketPayload {
        public final T packet;
        private final CustomPacketPayload.Type<NeoForgePacketWrapper<T>> type;

        public NeoForgePacketWrapper(T packet, CustomPacketPayload.Type<NeoForgePacketWrapper<T>> type) {
            this.packet = packet;
            this.type = type;
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return this.type;
        }
    }
}

