/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.networking.neoforge;

import com.iamkaf.amber.api.networking.v1.PacketContext;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.loading.FMLEnvironment;

public class NeoForgePacketContext
implements PacketContext {
    private final boolean isClientSide;
    private final Player player;

    public NeoForgePacketContext(boolean isClientSide, Player player) {
        this.isClientSide = isClientSide;
        this.player = player;
    }

    @Override
    public boolean isClientSide() {
        return this.isClientSide;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void execute(Runnable task) {
        if (this.isClientSide) {
            if (FMLEnvironment.getDist().isClient()) {
                Minecraft.getInstance().execute(task);
            } else {
                task.run();
            }
        } else {
            ServerPlayer serverPlayer;
            Player player = this.player;
            if (player instanceof ServerPlayer && (player = (serverPlayer = (ServerPlayer)player).level()) instanceof ServerLevel) {
                Player serverLevel = player;
                serverLevel.getServer().execute(task);
            } else {
                task.run();
            }
        }
    }
}

