/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.platform;

import com.iamkaf.amber.AmberMod;
import com.iamkaf.amber.api.event.v1.events.common.AnimalEvents;
import com.iamkaf.amber.api.event.v1.events.common.BlockEvents;
import com.iamkaf.amber.api.event.v1.events.common.CommandEvents;
import com.iamkaf.amber.api.event.v1.events.common.CreativeModeTabEvents;
import com.iamkaf.amber.api.event.v1.events.common.EntityEvent;
import com.iamkaf.amber.api.event.v1.events.common.ItemEvents;
import com.iamkaf.amber.api.event.v1.events.common.LootEvents;
import com.iamkaf.amber.api.event.v1.events.common.PlayerEvents;
import com.iamkaf.amber.api.event.v1.events.common.ServerTickEvents;
import com.iamkaf.amber.api.event.v1.events.common.WeatherEvents;
import com.iamkaf.amber.api.event.v1.events.common.WorldEvents;
import com.iamkaf.amber.api.event.v1.events.common.client.ClientCommandEvents;
import com.iamkaf.amber.api.event.v1.events.common.client.ClientTickEvents;
import com.iamkaf.amber.api.event.v1.events.common.client.HudEvents;
import com.iamkaf.amber.api.keymapping.KeybindHelper;
import com.iamkaf.amber.platform.services.IAmberEventSetup;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.KeyMapping;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.AnimalTameEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class NeoForgeAmberEventSetup
implements IAmberEventSetup {
    @Override
    public void registerCommon() {
        NeoForge.EVENT_BUS.register(EventHandlerCommonNeoForge.class);
        IEventBus bus = (IEventBus)AmberMod.getEventBus("amber");
        assert (bus != null);
        bus.register(ModBusEventHandler.class);
    }

    @Override
    public void registerClient() {
        NeoForge.EVENT_BUS.register(EventHandlerClientNeoForge.class);
        IEventBus bus = (IEventBus)AmberMod.getEventBus("amber");
        assert (bus != null);
        bus.register(EventHandlerClientMod.class);
    }

    @Override
    public void registerServer() {
        NeoForge.EVENT_BUS.register(EventHandlerServer.class);
    }

    public static class EventHandlerCommonNeoForge {
        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void event(LootTableLoadEvent event) {
            LootEvents.MODIFY.invoker().modify(event.getName(), lootPool -> event.getTable().addPool(lootPool.build()));
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void event(PlayerInteractEvent.EntityInteract event) {
            InteractionResult result = PlayerEvents.ENTITY_INTERACT.invoker().interact(event.getEntity(), event.getLevel(), event.getHand(), event.getTarget());
            LogicalSide side = event.getSide();
            if (result.equals((Object)InteractionResult.PASS)) {
                return;
            }
            if (side.isClient()) {
                if (result == InteractionResult.SUCCESS) {
                    event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                    event.setCanceled(true);
                } else if (result == InteractionResult.CONSUME) {
                    event.setCancellationResult((InteractionResult)InteractionResult.CONSUME);
                    event.setCanceled(true);
                } else {
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onCommandRegistration(RegisterCommandsEvent event) {
            CommandEvents.EVENT.invoker().register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
            EntityEvent.ENTITY_SPAWN.invoker().onEntitySpawn(event.getEntity(), event.getLevel());
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onLivingDeath(LivingDeathEvent event) {
            EntityEvent.ENTITY_DEATH.invoker().onEntityDeath(event.getEntity(), event.getSource());
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onLivingIncomingDamage(LivingIncomingDamageEvent event) {
            InteractionResult result = EntityEvent.ENTITY_DAMAGE.invoker().onEntityDamage(event.getEntity(), event.getSource(), event.getAmount());
            if (result != InteractionResult.PASS) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onWorldLoad(LevelEvent.Load event) {
            WorldEvents.WORLD_LOAD.invoker().onWorldLoad(event.getLevel().getServer(), event.getLevel());
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onWorldUnload(LevelEvent.Unload event) {
            WorldEvents.WORLD_UNLOAD.invoker().onWorldUnload(event.getLevel().getServer(), event.getLevel());
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onWorldSave(LevelEvent.Save event) {
            WorldEvents.WORLD_SAVE.invoker().onWorldSave(event.getLevel().getServer(), event.getLevel());
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onLightningStrike(EntityStruckByLightningEvent event) {
            InteractionResult result = WeatherEvents.LIGHTNING_STRIKE.invoker().onLightningStrike(event.getEntity(), event.getLightning());
            if (result != InteractionResult.PASS) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            InteractionResult result = BlockEvents.BLOCK_BREAK_BEFORE.invoker().beforeBlockBreak(event.getPlayer().level(), event.getPlayer(), event.getPos(), event.getState(), event.getLevel().getBlockEntity(event.getPos()));
            if (result != InteractionResult.PASS) {
                event.setCanceled(true);
                return;
            }
            BlockEvents.BLOCK_BREAK_AFTER.invoker().afterBlockBreak(event.getPlayer().level(), event.getPlayer(), event.getPos(), event.getState(), event.getLevel().getBlockEntity(event.getPos()));
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
            Entity entity = event.getEntity();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            InteractionResult result = BlockEvents.BLOCK_PLACE.invoker().onBlockPlace(player.level(), player, event.getPos(), event.getPlacedBlock(), player.getMainHandItem());
            if (result != InteractionResult.PASS) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
            InteractionResult result = BlockEvents.BLOCK_INTERACT.invoker().onBlockInteract(event.getEntity(), event.getEntity().level(), event.getHand(), new BlockHitResult(event.getHitVec().getLocation(), event.getFace(), event.getPos(), false));
            if (result != InteractionResult.PASS) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onBlockClick(PlayerInteractEvent.LeftClickBlock event) {
            InteractionResult result = BlockEvents.BLOCK_CLICK.invoker().onBlockClick(event.getEntity(), event.getEntity().level(), event.getHand(), event.getPos(), event.getFace());
            if (result != InteractionResult.PASS) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onAnimalTame(AnimalTameEvent event) {
            if (event.getTamer() == null) {
                return;
            }
            InteractionResult result = AnimalEvents.ANIMAL_TAME.invoker().onAnimalTame((LivingEntity)event.getAnimal(), event.getTamer());
            if (result != InteractionResult.PASS) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onAnimalBreed(BabyEntitySpawnEvent event) {
            Mob mob = event.getParentA();
            if (mob instanceof Animal) {
                Animal parentA = (Animal)mob;
                mob = event.getParentB();
                if (mob instanceof Animal) {
                    Animal parentB = (Animal)mob;
                    AnimalEvents.ANIMAL_BREED.invoker().onAnimalBreed(parentA, parentB, event.getChild());
                }
            }
        }
    }

    public static class ModBusEventHandler {
        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void buildContents(BuildCreativeModeTabContentsEvent event) {
            CreativeModeTabEvents.MODIFY_ENTRIES.invoker().modifyEntries((ResourceKey<CreativeModeTab>)event.getTabKey(), (arg_0, arg_1) -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0, arg_1));
        }
    }

    public static class EventHandlerClientNeoForge {
        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onCommandRegistration(RegisterClientCommandsEvent event) {
            ClientCommandEvents.EVENT.invoker().register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void eventRenderGameOverlayEvent(RenderGuiEvent.Post event) {
            HudEvents.RENDER_HUD.invoker().onHudRender(event.getGuiGraphics(), event.getPartialTick());
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onClientTickEventPre(ClientTickEvent.Pre event) {
            ClientTickEvents.START_CLIENT_TICK.invoker().onStartTick();
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onClientTickEventPost(ClientTickEvent.Post event) {
            ClientTickEvents.END_CLIENT_TICK.invoker().onEndTick();
        }
    }

    public static class EventHandlerClientMod {
        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onKeyMappingRegistration(RegisterKeyMappingsEvent event) {
            for (KeyMapping keyMapping : KeybindHelper.getKeybindings()) {
                event.register(keyMapping);
            }
            KeybindHelper.forgeEventAlreadyFired = true;
        }
    }

    public static class EventHandlerServer {
        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onServerTickEventPre(ServerTickEvent.Pre event) {
            ServerTickEvents.START_SERVER_TICK.invoker().onStartTick();
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onServerTickEventPost(ServerTickEvent.Post event) {
            ServerTickEvents.END_SERVER_TICK.invoker().onEndTick();
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PlayerEvents.PLAYER_JOIN.invoker().onPlayerJoin(serverPlayer);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PlayerEvents.PLAYER_LEAVE.invoker().onPlayerLeave(serverPlayer);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer newPlayer = (ServerPlayer)player;
                PlayerEvents.PLAYER_RESPAWN.invoker().onPlayerRespawn(newPlayer, newPlayer, !event.isEndConquered());
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onItemDrop(ItemTossEvent event) {
            ItemEvents.ITEM_DROP.invoker().onItemDrop(event.getPlayer(), event.getEntity());
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onItemPickup(ItemEntityPickupEvent.Pre event) {
            if (event.getItemEntity().hasPickUpDelay()) {
                return;
            }
            ItemEvents.ITEM_PICKUP.invoker().onItemPickup(event.getPlayer(), event.getItemEntity(), event.getItemEntity().getItem());
        }
    }
}

