/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.platform;

import com.iamkaf.amber.api.platform.v1.ModInfo;
import com.iamkaf.amber.platform.services.IPlatformHelper;
import com.iamkaf.amber.util.Env;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Collectors;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.Nullable;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.getCurrent().isProduction();
    }

    @Override
    public Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public Env getEnvironment() {
        switch (FMLLoader.getCurrent().getDist()) {
            case CLIENT: {
                return Env.CLIENT;
            }
            case DEDICATED_SERVER: {
                return Env.SERVER;
            }
        }
        throw new IllegalStateException("Unknown environment type: " + String.valueOf(FMLLoader.getCurrent().getDist()));
    }

    @Override
    public Collection<String> getModIds() {
        return ModList.get().getMods().stream().map(IModInfo::getModId).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public ModInfo getModInfo(String modId) {
        return ModList.get().getModContainerById(modId).map(container -> new ModInfo(container.getModId(), container.getModInfo().getDisplayName(), container.getModInfo().getVersion().toString(), container.getModInfo().getDescription())).orElse(null);
    }
}

