/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.platform;

import com.iamkaf.amber.api.registry.v1.Registrar;
import com.iamkaf.amber.api.registry.v1.RegistrySupplier;
import com.iamkaf.amber.platform.services.IRegistrarManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NeoForgeRegistrarManager
implements IRegistrarManager {
    private final Map<String, Map<ResourceKey<? extends Registry<?>>, DeferredRegister<?>>> registers = new HashMap();

    private <T> DeferredRegister<T> getRegister(String modId, ResourceKey<Registry<T>> key) {
        Map map = this.registers.computeIfAbsent(modId, m -> new HashMap());
        return map.computeIfAbsent(key, k -> {
            DeferredRegister reg = DeferredRegister.create((ResourceKey)key, (String)modId);
            reg.register(Objects.requireNonNull(ModLoadingContext.get().getActiveContainer().getEventBus()));
            return reg;
        });
    }

    @Override
    public <T> Registrar<T> create(String modId, ResourceKey<Registry<T>> key) {
        return new NeoForgeRegistrar<T>(key, this.getRegister(modId, key));
    }

    private static class NeoForgeRegistrar<T>
    implements Registrar<T> {
        private final ResourceKey<Registry<T>> key;
        private final DeferredRegister<T> register;

        NeoForgeRegistrar(ResourceKey<Registry<T>> key, DeferredRegister<T> register) {
            this.key = key;
            this.register = register;
        }

        @Override
        public <R extends T> RegistrySupplier<R> register(ResourceLocation id, Supplier<? extends R> supplier) {
            DeferredHolder holder = this.register.register(id.getPath(), supplier);
            return new NeoForgeRegistrySupplier(this.key.location(), id, holder);
        }

        @Override
        public ResourceKey<? extends Registry<T>> key() {
            return this.key;
        }

        @Override
        public Optional<Holder.Reference<T>> get(ResourceLocation id) {
            return this.registry().get(id);
        }

        private Registry<T> registry() {
            return (Registry)BuiltInRegistries.REGISTRY.getValue(this.key.location());
        }
    }

    private static class NeoForgeRegistrySupplier<T, R extends T>
    implements RegistrySupplier<R> {
        private final ResourceLocation registryId;
        private final ResourceLocation id;
        private final DeferredHolder<T, R> holder;

        NeoForgeRegistrySupplier(ResourceLocation registryId, ResourceLocation id, DeferredHolder<T, R> holder) {
            this.registryId = registryId;
            this.id = id;
            this.holder = holder;
        }

        @Override
        public boolean isPresent() {
            return this.holder.isBound();
        }

        @Override
        public R get() {
            return (R)this.holder.get();
        }

        @Override
        public ResourceLocation getRegistryId() {
            return this.registryId;
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }
    }
}

