/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.networking.v1;

import com.iamkaf.amber.api.networking.v1.NetworkChannel;
import com.iamkaf.amber.api.networking.v1.Packet;
import com.iamkaf.amber.api.networking.v1.PacketDecoder;
import com.iamkaf.amber.api.networking.v1.PacketEncoder;
import com.iamkaf.amber.api.networking.v1.PacketHandler;
import com.iamkaf.amber.api.networking.v1.PlatformNetworkChannel;
import com.iamkaf.amber.platform.Services;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

class NetworkChannelImpl
implements NetworkChannel {
    private static final ConcurrentMap<class_2960, NetworkChannelImpl> CHANNELS = new ConcurrentHashMap<class_2960, NetworkChannelImpl>();
    private final class_2960 channelId;
    private final PlatformNetworkChannel platformChannel;

    private NetworkChannelImpl(class_2960 channelId) {
        this.channelId = channelId;
        this.platformChannel = Services.NETWORKING.createChannel(channelId);
    }

    static NetworkChannel create(class_2960 channelId) {
        return CHANNELS.computeIfAbsent(channelId, NetworkChannelImpl::new);
    }

    @Override
    public <T extends Packet<T>> void register(Class<T> packetClass, PacketEncoder<T> encoder, PacketDecoder<T> decoder, PacketHandler<T> handler) {
        this.platformChannel.register(packetClass, encoder, decoder, handler);
    }

    @Override
    public <T extends Packet<T>> void sendToServer(T packet) {
        this.platformChannel.sendToServer(packet);
    }

    @Override
    public <T extends Packet<T>> void sendToPlayer(T packet, class_3222 player) {
        this.platformChannel.sendToPlayer(packet, player);
    }

    @Override
    public <T extends Packet<T>> void sendToAllPlayers(T packet) {
        this.platformChannel.sendToAllPlayers(packet);
    }

    @Override
    public <T extends Packet<T>> void sendToAllPlayersExcept(T packet, class_3222 except) {
        this.platformChannel.sendToAllPlayersExcept(packet, except);
    }

    @Override
    public class_2960 getChannelId() {
        return this.channelId;
    }
}

