/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.networking.v1.examples;

import com.iamkaf.amber.Constants;
import com.iamkaf.amber.api.networking.v1.NetworkChannel;
import com.iamkaf.amber.api.networking.v1.examples.PingPacket;
import com.iamkaf.amber.api.networking.v1.examples.PongPacket;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class NetworkingExample {
    public static final NetworkChannel CHANNEL = NetworkChannel.create(class_2960.method_60655((String)"amber", (String)"example"));

    public static void init() {
        CHANNEL.register(PingPacket.class, PingPacket::encode, PingPacket::decode, PingPacket::handle);
        CHANNEL.register(PongPacket.class, PongPacket::encode, PongPacket::decode, PongPacket::handle);
        Constants.LOG.info("Networking example initialized - ready to ping!");
    }

    public static void pingPlayer(class_3222 player) {
        long timestamp = System.currentTimeMillis();
        String message = "Hello from server!";
        PingPacket ping = new PingPacket(timestamp, message);
        CHANNEL.sendToPlayer(ping, player);
        Constants.LOG.info("Sent ping to {}", (Object)player.method_5477().getString());
    }

    public static void pingAllPlayers() {
        long timestamp = System.currentTimeMillis();
        String message = "Broadcast ping from server!";
        PingPacket ping = new PingPacket(timestamp, message);
        CHANNEL.sendToAllPlayers(ping);
        Constants.LOG.info("Sent broadcast ping to all players");
    }

    public static void sendCustomMessage() {
        long timestamp = System.currentTimeMillis();
        PongPacket message = new PongPacket(timestamp, timestamp, "Hello from client!");
        CHANNEL.sendToServer(message);
        Constants.LOG.info("Sent custom message to server");
    }
}

