/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.networking.v1;

import com.iamkaf.amber.Constants;
import com.iamkaf.amber.api.networking.v1.Packet;
import com.iamkaf.amber.api.networking.v1.PacketDecoder;
import com.iamkaf.amber.api.networking.v1.PacketEncoder;
import com.iamkaf.amber.api.networking.v1.PacketHandler;
import com.iamkaf.amber.networking.v1.AmberNetworking;

public record PongPacket(long originalTimestamp, long responseTimestamp, String message) implements Packet<PongPacket>
{
    public static final PacketEncoder<PongPacket> ENCODER = (packet, buffer) -> {
        buffer.method_10791(packet.originalTimestamp);
        buffer.method_10791(packet.responseTimestamp);
        buffer.method_10814(packet.message);
    };
    public static final PacketDecoder<PongPacket> DECODER = buffer -> {
        long originalTimestamp = buffer.method_10792();
        long responseTimestamp = buffer.method_10792();
        String message = buffer.method_19772();
        return new PongPacket(originalTimestamp, responseTimestamp, message);
    };
    public static final PacketHandler<PongPacket> HANDLER = (packet, context) -> {
        if (!context.isClientSide()) {
            context.execute(() -> {
                long currentTime = System.currentTimeMillis();
                long totalRoundTrip = currentTime - packet.originalTimestamp();
                long clientProcessingTime = packet.responseTimestamp() - packet.originalTimestamp();
                long networkLatency = totalRoundTrip - clientProcessingTime;
                Constants.LOG.debug("Amber received pong: {}", (Object)packet.message());
                Constants.LOG.debug("  Total round-trip time: {}ms", (Object)totalRoundTrip);
                Constants.LOG.debug("  Client processing time: {}ms", (Object)clientProcessingTime);
                Constants.LOG.debug("  Estimated network latency: {}ms", (Object)networkLatency);
                AmberNetworking.recordLatency(totalRoundTrip, networkLatency);
            });
        } else {
            Constants.LOG.warn("PongPacket received on client side - this should not happen");
        }
    };
}

