/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.platform;

import com.iamkaf.amber.api.platform.v1.ModInfo;
import com.iamkaf.amber.platform.services.IPlatformHelper;
import com.iamkaf.amber.util.Env;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.jetbrains.annotations.Nullable;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public Path getConfigDirectory() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public Env getEnvironment() {
        return switch (FabricLoader.getInstance().getEnvironmentType()) {
            case EnvType.CLIENT -> Env.CLIENT;
            case EnvType.SERVER -> Env.SERVER;
            default -> throw new IllegalStateException("Unknown environment type: " + String.valueOf(FabricLoader.getInstance().getEnvironmentType()));
        };
    }

    @Override
    public Collection<String> getModIds() {
        return FabricLoader.getInstance().getAllMods().stream().map(ModContainer::getMetadata).map(ModMetadata::getId).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public ModInfo getModInfo(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).map(mod -> {
            ModMetadata metadata = mod.getMetadata();
            return new ModInfo(metadata.getId(), metadata.getName(), metadata.getVersion().getFriendlyString(), metadata.getDescription());
        }).orElse(null);
    }
}

