/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.networking.v1.examples;

import com.iamkaf.amber.Constants;
import com.iamkaf.amber.api.networking.v1.Packet;
import com.iamkaf.amber.api.networking.v1.PacketContext;
import net.minecraft.class_2540;

public record PongPacket(long originalTimestamp, long responseTimestamp, String message) implements Packet<PongPacket>
{
    public static void encode(PongPacket packet, class_2540 buffer) {
        buffer.method_10791(packet.originalTimestamp);
        buffer.method_10791(packet.responseTimestamp);
        buffer.method_10814(packet.message);
    }

    public static PongPacket decode(class_2540 buffer) {
        long originalTimestamp = buffer.method_10792();
        long responseTimestamp = buffer.method_10792();
        String message = buffer.method_19772();
        return new PongPacket(originalTimestamp, responseTimestamp, message);
    }

    public static void handle(PongPacket packet, PacketContext context) {
        if (context.isServerSide()) {
            context.execute(() -> {
                long currentTime = System.currentTimeMillis();
                long totalRoundTrip = currentTime - packet.originalTimestamp;
                long clientProcessingTime = packet.responseTimestamp - packet.originalTimestamp;
                long networkLatency = totalRoundTrip - clientProcessingTime;
                Constants.LOG.info("Server received pong: {}", (Object)packet.message);
                Constants.LOG.info("  Total round-trip: {}ms", (Object)totalRoundTrip);
                Constants.LOG.info("  Client processing: {}ms", (Object)clientProcessingTime);
                Constants.LOG.info("  Network latency: {}ms", (Object)networkLatency);
                PongPacket.recordLatency(totalRoundTrip, networkLatency);
            });
        } else {
            Constants.LOG.error("Client received pong packet - this should not happen!");
        }
    }

    private static void recordLatency(long totalLatency, long networkLatency) {
        Constants.LOG.info("Recorded latency: {}ms", (Object)networkLatency);
    }
}

