/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.registry.v1;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.iamkaf.amber.api.registry.v1.Registrar;
import com.iamkaf.amber.api.registry.v1.RegistrarManager;
import com.iamkaf.amber.api.registry.v1.RegistrySupplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

public class DeferredRegister<T>
implements Iterable<RegistrySupplier<T>> {
    private final java.util.function.Supplier<RegistrarManager> managerSupplier;
    private final class_5321<class_2378<T>> key;
    private final List<Entry<T>> entries = new ArrayList<Entry<T>>();
    private final List<RegistrySupplier<T>> entryView = Collections.unmodifiableList(this.entries);
    private boolean registered = false;
    private final String modId;

    private DeferredRegister(java.util.function.Supplier<RegistrarManager> managerSupplier, class_5321<class_2378<T>> key, String modId) {
        this.managerSupplier = Objects.requireNonNull(managerSupplier);
        this.key = Objects.requireNonNull(key);
        this.modId = modId;
    }

    public static <T> DeferredRegister<T> create(String modId, class_5321<class_2378<T>> key) {
        Supplier value = Suppliers.memoize(() -> RegistrarManager.get(modId));
        return new DeferredRegister<T>((java.util.function.Supplier<RegistrarManager>)value, key, modId);
    }

    public <R extends T> RegistrySupplier<R> register(String id, java.util.function.Supplier<? extends R> supplier) {
        if (this.modId == null) {
            throw new NullPointerException("DeferredRegister created without mod id");
        }
        return this.register(class_2960.method_60655((String)this.modId, (String)id), supplier);
    }

    public <R extends T> RegistrySupplier<R> register(String id, Function<class_5321<T>, ? extends R> supplier) {
        if (this.modId == null) {
            throw new NullPointerException("DeferredRegister created without mod id");
        }
        return this.register(class_2960.method_60655((String)this.modId, (String)id), supplier);
    }

    public <R extends T> RegistrySupplier<R> register(class_2960 id, java.util.function.Supplier<? extends R> supplier) {
        Entry<? extends R> entry = new Entry<R>(id, supplier);
        this.entries.add(entry);
        if (this.registered) {
            Registrar<T> registrar = this.getRegistrar();
            entry.value = registrar.register(entry.id, entry.supplier);
        }
        return entry;
    }

    public <R extends T> RegistrySupplier<R> register(class_2960 id, Function<class_5321<T>, ? extends R> supplier) {
        return this.register(id, () -> supplier.apply(class_5321.method_29179(this.key, (class_2960)id)));
    }

    public void register() {
        if (this.registered) {
            throw new IllegalStateException("Cannot register a deferred register twice!");
        }
        this.registered = true;
        Registrar<T> registrar = this.getRegistrar();
        for (Entry<T> entry : this.entries) {
            entry.value = registrar.register(entry.id, entry.supplier);
        }
    }

    @Override
    @NotNull
    public Iterator<RegistrySupplier<T>> iterator() {
        return this.entryView.iterator();
    }

    public RegistrarManager getRegistrarManager() {
        return this.managerSupplier.get();
    }

    public Registrar<T> getRegistrar() {
        return this.managerSupplier.get().get(this.key);
    }

    private class Entry<R>
    implements RegistrySupplier<R> {
        private final class_2960 id;
        private final java.util.function.Supplier<R> supplier;
        private RegistrySupplier<R> value;

        Entry(class_2960 id, java.util.function.Supplier<R> supplier) {
            this.id = id;
            this.supplier = supplier;
        }

        @Override
        public boolean isPresent() {
            return this.value != null && this.value.isPresent();
        }

        @Override
        public R get() {
            if (this.isPresent()) {
                return (R)this.value.get();
            }
            throw new NullPointerException("Registry object not present: " + String.valueOf(this.id));
        }

        @Override
        public class_2960 getRegistryId() {
            return this.getRegistrar().key().method_29177();
        }

        @Override
        public class_2960 getId() {
            return this.id;
        }

        private Registrar<R> getRegistrar() {
            return DeferredRegister.this.getRegistrar();
        }
    }
}

