/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.networking.fabric;

import com.iamkaf.amber.api.networking.v1.Packet;
import com.iamkaf.amber.api.networking.v1.PacketDecoder;
import com.iamkaf.amber.api.networking.v1.PacketEncoder;
import com.iamkaf.amber.api.networking.v1.PacketHandler;
import com.iamkaf.amber.api.networking.v1.PlatformNetworkChannel;
import com.iamkaf.amber.networking.fabric.FabricClientNetworking;
import com.iamkaf.amber.networking.fabric.FabricPacketContext;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class FabricNetworkChannelImpl
implements PlatformNetworkChannel {
    private final class_2960 channelId;
    private final ConcurrentMap<Class<?>, PacketRegistration<? extends Packet<?>>> registrations = new ConcurrentHashMap();

    public FabricNetworkChannelImpl(class_2960 channelId) {
        this.channelId = channelId;
    }

    @Override
    public <T extends Packet<T>> void register(Class<T> packetClass, PacketEncoder<T> encoder, PacketDecoder<T> decoder, PacketHandler<T> handler) {
        PacketRegistration<T> registration = new PacketRegistration<T>(encoder, decoder, handler);
        this.registrations.put(packetClass, registration);
        class_2960 packetId = class_2960.method_60655((String)this.channelId.method_12836(), (String)(this.channelId.method_12832() + "/" + packetClass.getSimpleName().toLowerCase()));
        class_8710.class_9154 payloadType = new class_8710.class_9154(packetId);
        class_9139 streamCodec = class_9139.method_56437((buffer, wrapper) -> encoder.encode(wrapper.packet, (class_2540)buffer), buffer -> new FabricPacketWrapper(decoder.decode((class_2540)buffer), payloadType));
        PayloadTypeRegistry.playS2C().register(payloadType, streamCodec);
        PayloadTypeRegistry.playC2S().register(payloadType, streamCodec);
        ServerPlayNetworking.registerGlobalReceiver((class_8710.class_9154)payloadType, (payload, context) -> {
            FabricPacketContext packetContext = new FabricPacketContext(false, (class_1657)context.player());
            handler.handle(payload.packet, packetContext);
        });
        if (this.isClientEnvironment()) {
            FabricClientNetworking.registerClientReceiver(payloadType, handler);
        }
    }

    @Override
    public <T extends Packet<T>> void sendToServer(T packet) {
        if (!this.isClientEnvironment()) {
            throw new IllegalStateException("sendToServer can only be called from client side");
        }
        PacketRegistration registration = (PacketRegistration)this.registrations.get(packet.getClass());
        if (registration == null) {
            throw new IllegalArgumentException("Packet not registered: " + packet.getClass().getName());
        }
        class_2960 packetId = class_2960.method_60655((String)this.channelId.method_12836(), (String)(this.channelId.method_12832() + "/" + packet.getClass().getSimpleName().toLowerCase()));
        class_8710.class_9154 payloadType = new class_8710.class_9154(packetId);
        FabricPacketWrapper<T> wrapper = new FabricPacketWrapper<T>(packet, payloadType);
        FabricClientNetworking.sendToServer(wrapper);
    }

    @Override
    public <T extends Packet<T>> void sendToPlayer(T packet, class_3222 player) {
        PacketRegistration registration = (PacketRegistration)this.registrations.get(packet.getClass());
        if (registration == null) {
            throw new IllegalArgumentException("Packet not registered: " + packet.getClass().getName());
        }
        class_2960 packetId = class_2960.method_60655((String)this.channelId.method_12836(), (String)(this.channelId.method_12832() + "/" + packet.getClass().getSimpleName().toLowerCase()));
        class_8710.class_9154 payloadType = new class_8710.class_9154(packetId);
        FabricPacketWrapper<T> wrapper = new FabricPacketWrapper<T>(packet, payloadType);
        ServerPlayNetworking.send((class_3222)player, wrapper);
    }

    @Override
    public <T extends Packet<T>> void sendToAllPlayers(T packet) {
        PacketRegistration registration = (PacketRegistration)this.registrations.get(packet.getClass());
        if (registration == null) {
            throw new IllegalArgumentException("Packet not registered: " + packet.getClass().getName());
        }
        class_2960 packetId = class_2960.method_60655((String)this.channelId.method_12836(), (String)(this.channelId.method_12832() + "/" + packet.getClass().getSimpleName().toLowerCase()));
        class_8710.class_9154 payloadType = new class_8710.class_9154(packetId);
        FabricPacketWrapper<T> wrapper = new FabricPacketWrapper<T>(packet, payloadType);
        for (class_3222 player : PlayerLookup.all(null)) {
            ServerPlayNetworking.send((class_3222)player, wrapper);
        }
    }

    @Override
    public <T extends Packet<T>> void sendToAllPlayersExcept(T packet, class_3222 except) {
        PacketRegistration registration = (PacketRegistration)this.registrations.get(packet.getClass());
        if (registration == null) {
            throw new IllegalArgumentException("Packet not registered: " + packet.getClass().getName());
        }
        class_2960 packetId = class_2960.method_60655((String)this.channelId.method_12836(), (String)(this.channelId.method_12832() + "/" + packet.getClass().getSimpleName().toLowerCase()));
        class_8710.class_9154 payloadType = new class_8710.class_9154(packetId);
        FabricPacketWrapper<T> wrapper = new FabricPacketWrapper<T>(packet, payloadType);
        for (class_3222 player : PlayerLookup.all((MinecraftServer)except.method_51469().method_8503())) {
            if (player.equals((Object)except)) continue;
            ServerPlayNetworking.send((class_3222)player, wrapper);
        }
    }

    private boolean isClientEnvironment() {
        try {
            return EnvType.CLIENT.equals((Object)FabricLoader.getInstance().getEnvironmentType());
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class PacketRegistration<T extends Packet<T>> {
        final PacketEncoder<T> encoder;
        final PacketDecoder<T> decoder;
        final PacketHandler<T> handler;

        PacketRegistration(PacketEncoder<T> encoder, PacketDecoder<T> decoder, PacketHandler<T> handler) {
            this.encoder = encoder;
            this.decoder = decoder;
            this.handler = handler;
        }
    }

    public static class FabricPacketWrapper<T extends Packet<T>>
    implements class_8710 {
        public final T packet;
        private final class_8710.class_9154<FabricPacketWrapper<T>> type;

        public FabricPacketWrapper(T packet, class_8710.class_9154<FabricPacketWrapper<T>> type) {
            this.packet = packet;
            this.type = type;
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return this.type;
        }
    }
}

