package io.github.gameking1happy.gk1hcore.platform;

import io.github.gameking1happy.gk1hcore.packs.addPacks;
import io.github.gameking1happy.gk1hcore.platform.services.IPlatformHelper;
import java.util.ServiceLoader;

import static io.github.gameking1happy.gk1hcore.Main.LOG;
public class Services {
    // Platform helper which provides information which platform the mod is running on.
    public static final IPlatformHelper PLATFORM = load(IPlatformHelper.class);
    @SuppressWarnings("unused")
    public static final addPacks ADDPACKS = load(addPacks.class);
    // This code is used to load a service for the current environment.
    public static <T> T load(Class<T> clazz) {
        final T loadedService = ServiceLoader.load(clazz)
                .findFirst()
                .orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        LOG.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}