package io.github.gameking1happy.gk1hcore.platform;

import io.github.gameking1happy.gk1hcore.platform.services.IPlatformHelper;
import net.neoforged.fml.ModList;

import static net.neoforged.fml.loading.FMLLoader.isProduction;

/**
 * NeoForge code for the platform helper which provides information which platform the mod is running on.
 */
public class NeoForgePlatformHelper implements IPlatformHelper {

    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !isProduction();
    }
}