package io.github.gameking1happy.gk1hcore.mixin;

import io.github.gameking1happy.gk1hcore.Main;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import java.util.List;
import net.minecraft.class_3288;
import net.minecraft.class_5369;

@Mixin(class_5369.class)
public abstract class PackSelectionModelMixin {
    @Shadow @Final List<class_3288> selected;
    @Shadow @Final List<class_3288> unselected;
    @Inject(
            method = "findNewPacks",
            at = @At("TAIL")
    )
    private void filterPacks(CallbackInfo ci) {
        selected.removeIf(pack -> Main.packContainsAnyFromList(pack, Main.PackExclusions));
        unselected.removeIf(pack -> Main.packContainsAnyFromList(pack, Main.PackExclusions));
    }
}