/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.survivalchallenge;

import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.data.Ageable;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SurvivalChallengePlugin
extends JavaPlugin
implements Listener {
    private int currentDay = 0;
    private boolean challengeActive = false;
    private boolean challengeCompleted = false;
    private String challengeType = "";
    private int challengeTarget = 0;
    private int progress = 0;
    private BossBar bossBar = null;

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.bossBar = Bukkit.createBossBar((String)"No active challenge", (BarColor)BarColor.PURPLE, (BarStyle)BarStyle.SEGMENTED_10, (BarFlag[])new BarFlag[]{BarFlag.CREATE_FOG});
        new BukkitRunnable(){

            public void run() {
                World world = (World)Bukkit.getWorlds().get(0);
                long day = world.getFullTime() / 24000L;
                if ((int)day != SurvivalChallengePlugin.this.currentDay) {
                    SurvivalChallengePlugin.this.currentDay = (int)day;
                    SurvivalChallengePlugin.this.checkDay(SurvivalChallengePlugin.this.currentDay);
                }
                String dayMsg = String.valueOf(ChatColor.GOLD) + "\u2600 Day " + SurvivalChallengePlugin.this.currentDay;
                for (Player p : Bukkit.getOnlinePlayers()) {
                    p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(dayMsg));
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 200L);
    }

    public void onDisable() {
        if (this.bossBar != null) {
            this.bossBar.removeAll();
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        final Player p = event.getPlayer();
        if (this.bossBar != null && this.challengeActive && !this.challengeCompleted && !this.bossBar.getPlayers().contains(p)) {
            this.bossBar.addPlayer(p);
        }
        if (!this.getConfig().getBoolean("players." + String.valueOf(p.getUniqueId()) + ".joinedBefore", false)) {
            this.getConfig().set("players." + String.valueOf(p.getUniqueId()) + ".joinedBefore", (Object)true);
            this.saveConfig();
            new BukkitRunnable(this){

                public void run() {
                    if (!p.isOnline()) {
                        return;
                    }
                    p.sendTitle(String.valueOf(ChatColor.AQUA) + "Welcome, " + p.getName() + "!", String.valueOf(ChatColor.GREEN) + "Your journey begins now!", 10, 70, 20);
                    p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
                    p.getInventory().addItem(new ItemStack[]{new ItemStack(Material.OAK_PLANKS, 4)});
                    p.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BAMBOO, 1)});
                }
            }.runTaskLater((Plugin)this, 100L);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player p = event.getPlayer();
        if (this.bossBar != null) {
            this.bossBar.removePlayer(p);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        Ageable ageable;
        if (!this.challengeActive || this.challengeCompleted) {
            return;
        }
        Block block = e.getBlock();
        if (this.challengeType.equals("block") && block.getType() == Material.DIRT) {
            this.incrementProgress(e.getPlayer(), 1);
        }
        if (this.challengeType.equals("wheat") && block.getType() == Material.WHEAT && block.getBlockData() instanceof Ageable && (ageable = (Ageable)block.getBlockData()).getAge() >= ageable.getMaximumAge()) {
            this.incrementProgress(e.getPlayer(), 1);
        }
    }

    @EventHandler
    public void onEntityKill(EntityDeathEvent e) {
        if (!this.challengeActive || this.challengeCompleted) {
            return;
        }
        if (!(e.getEntity().getKiller() instanceof Player)) {
            return;
        }
        Player killer = e.getEntity().getKiller();
        boolean counted = false;
        switch (this.challengeType) {
            case "slime": {
                if (!(e.getEntity() instanceof Slime)) break;
                counted = true;
                break;
            }
            case "skeleton": {
                if (!(e.getEntity() instanceof Skeleton)) break;
                counted = true;
                break;
            }
            case "creeper": {
                if (!(e.getEntity() instanceof Creeper)) break;
                counted = true;
                break;
            }
            case "zombie": {
                if (!(e.getEntity() instanceof Zombie)) break;
                counted = true;
                break;
            }
            case "blaze_enderman": {
                if (!(e.getEntity() instanceof Blaze) && !(e.getEntity() instanceof Enderman)) break;
                counted = true;
            }
        }
        if (counted) {
            this.incrementProgress(killer, 1);
        }
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent e) {
        if (!this.challengeActive || this.challengeCompleted) {
            return;
        }
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getEntity();
        ItemStack item = e.getItem().getItemStack();
        if (this.challengeType.equals("rotten_flesh") && item.getType() == Material.ROTTEN_FLESH) {
            this.incrementProgress(p, 1);
        } else if (this.challengeType.equals("iron") && item.getType() == Material.IRON_INGOT) {
            this.incrementProgress(p, 1);
        }
    }

    @EventHandler
    public void onFish(PlayerFishEvent e) {
        if (!this.challengeActive || this.challengeCompleted) {
            return;
        }
        if (!this.challengeType.equals("fish")) {
            return;
        }
        if (e.getState() == PlayerFishEvent.State.CAUGHT_FISH && e.getCaught() instanceof Item) {
            this.incrementProgress(e.getPlayer(), 1);
        }
    }

    private void incrementProgress(Player who, int amount) {
        this.progress += amount;
        this.updateBossBar();
        who.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(String.valueOf(ChatColor.YELLOW) + "Progress: " + this.progress + "/" + this.challengeTarget));
        this.checkCompletion(who);
    }

    private void updateBossBar() {
        if (this.bossBar == null) {
            return;
        }
        if (!this.challengeActive || this.challengeCompleted) {
            this.bossBar.setVisible(false);
            return;
        }
        this.bossBar.setVisible(true);
        double fraction = Math.min(1.0, (double)this.progress / (double)this.challengeTarget);
        this.bossBar.setProgress(fraction);
    }

    private void checkDay(int day) {
        switch (day) {
            case 10: {
                this.startChallenge("slime", 20);
                break;
            }
            case 20: {
                this.startChallenge("block", 32);
                break;
            }
            case 30: {
                this.startChallenge("skeleton", 10);
                break;
            }
            case 40: {
                this.startChallenge("rotten_flesh", 50);
                break;
            }
            case 50: {
                this.startChallenge("fish", 10);
                break;
            }
            case 60: {
                this.startChallenge("iron", 32);
                break;
            }
            case 70: {
                this.startChallenge("wheat", 20);
                break;
            }
            case 80: {
                this.startChallenge("zombie", 25);
                break;
            }
            case 90: {
                this.startChallenge("creeper", 50);
                break;
            }
            case 100: {
                this.startChallenge("blaze_enderman", 20);
            }
        }
    }

    private void startChallenge(String type, int target) {
        this.challengeActive = true;
        this.challengeCompleted = false;
        this.challengeType = type;
        this.challengeTarget = target;
        this.progress = 0;
        String desc = switch (type) {
            case "slime" -> "Kill Slimes";
            case "block" -> "Break Dirt Blocks";
            case "skeleton" -> "Kill Skeletons";
            case "rotten_flesh" -> "Collect Rotten Flesh";
            case "fish" -> "Catch Fish";
            case "iron" -> "Collect Iron Ingots";
            case "wheat" -> "Harvest Wheat";
            case "zombie" -> "Kill Zombies";
            case "creeper" -> "Kill Creepers";
            case "blaze_enderman" -> "Kill Blazes or Endermen";
            default -> "Complete Challenge";
        };
        this.bossBar.setVisible(true);
        this.bossBar.setTitle(String.valueOf(ChatColor.LIGHT_PURPLE) + desc + String.valueOf(ChatColor.GRAY) + " | " + String.valueOf(ChatColor.YELLOW) + "0/" + target);
        this.bossBar.setProgress(0.0);
        this.bossBar.setColor(BarColor.PURPLE);
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!this.bossBar.getPlayers().contains(p)) {
                this.bossBar.addPlayer(p);
            }
            p.sendTitle(String.valueOf(ChatColor.LIGHT_PURPLE) + "New Challenge!", String.valueOf(ChatColor.AQUA) + desc + String.valueOf(ChatColor.GRAY) + " | " + String.valueOf(ChatColor.GREEN) + "Goal: " + String.valueOf(ChatColor.YELLOW) + target, 10, 70, 20);
            p.playSound(p.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.0f, 1.0f);
        }
        Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.LIGHT_PURPLE) + "New Challenge! " + String.valueOf(ChatColor.AQUA) + desc + String.valueOf(ChatColor.GRAY) + " | " + String.valueOf(ChatColor.GREEN) + "Goal: " + String.valueOf(ChatColor.YELLOW) + target));
    }

    private void checkCompletion(Player player) {
        if (this.progress >= this.challengeTarget && !this.challengeCompleted) {
            this.challengeCompleted = true;
            String reward = this.giveReward(player);
            for (Player p : Bukkit.getOnlinePlayers()) {
                p.sendTitle(String.valueOf(ChatColor.GREEN) + "Congratulations!", String.valueOf(ChatColor.YELLOW) + "Day " + this.currentDay + " challenge complete! Reward: " + String.valueOf(ChatColor.AQUA) + reward, 10, 100, 20);
                p.playSound(p.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
            }
            this.bossBar.setVisible(false);
        }
    }

    private String giveReward(Player player) {
        String rewardName = "Unknown";
        switch (this.currentDay) {
            case 10: {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.COOKED_BEEF, 64)});
                rewardName = "64 Cooked Beef";
                break;
            }
            case 20: {
                ItemStack shulker = new ItemStack(Material.GREEN_SHULKER_BOX, 1);
                BlockStateMeta meta = (BlockStateMeta)shulker.getItemMeta();
                ShulkerBox box = (ShulkerBox)meta.getBlockState();
                for (int i = 0; i < box.getInventory().getSize(); ++i) {
                    box.getInventory().setItem(i, new ItemStack(Material.GRASS_BLOCK, 64));
                }
                meta.setBlockState((BlockState)box);
                shulker.setItemMeta((ItemMeta)meta);
                player.getInventory().addItem(new ItemStack[]{shulker});
                rewardName = "Green Shulker Box of Grass";
                break;
            }
            case 30: {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.OBSIDIAN, 10)});
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.FLINT_AND_STEEL, 1)});
                rewardName = "Obsidian + Flint & Steel";
                break;
            }
            case 40: {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.LAVA_BUCKET, 1)});
                rewardName = "Lava Bucket";
                break;
            }
            case 50: {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.CHERRY_SAPLING, 1)});
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.OAK_SAPLING, 1)});
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.SPRUCE_SAPLING, 1)});
                rewardName = "Saplings";
                break;
            }
            case 60: {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.DIAMOND, 16)});
                rewardName = "16 Diamonds";
                break;
            }
            case 70: {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.GOLDEN_APPLE, 10)});
                rewardName = "10 Golden Apples";
                break;
            }
            case 80: {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.NETHERITE_INGOT, 1)});
                rewardName = "Mzee Krr";
                break;
            }
            case 90: {
                ItemStack sword = new ItemStack(Material.DIAMOND_SWORD);
                sword.addUnsafeEnchantment(Enchantment.SHARPNESS, 5);
                sword.addUnsafeEnchantment(Enchantment.UNBREAKING, 3);
                player.getInventory().addItem(new ItemStack[]{sword});
                rewardName = "Sharpness V Diamond Sword";
                break;
            }
            case 100: {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.END_PORTAL_FRAME, 12)});
                rewardName = "End Portal Frames";
            }
        }
        return rewardName;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("announce")) {
            if (args.length == 0) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /announce <message>");
                return true;
            }
            final String msg = String.join((CharSequence)" ", args);
            new BukkitRunnable(this){

                public void run() {
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        p.sendTitle(String.valueOf(ChatColor.GOLD) + msg, "", 10, 70, 20);
                    }
                }
            }.runTaskLater((Plugin)this, 100L);
            if (!(sender instanceof ConsoleCommandSender)) {
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Announcement scheduled!");
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("time")) {
            if (args.length >= 2 && args[0].equalsIgnoreCase("set")) {
                String arg = args[1].replace("d", "");
                try {
                    int day = Integer.parseInt(arg);
                    World world = (World)Bukkit.getWorlds().get(0);
                    world.setFullTime((long)day * 24000L);
                    this.currentDay = day;
                    this.checkDay(this.currentDay);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Set to day " + day + " and triggered challenge.");
                }
                catch (NumberFormatException ex) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid format! Use /time set 10d");
                }
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /time set <Xd>");
            return true;
        }
        return false;
    }
}

